<?php

class ShippingmethodController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','GetShippingmethodList','SaveShippingMethod','DeleteShippingmethod','DirectAdd', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    public function actionCreate()
    {
        $model=new MasShipping();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model), false, true);
    }
    public function actionGetShippingmethodList()
    {
            
        $model=new MasShipping();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        0 =>'via',
        1 =>'description',
        2 => 'isBaseShippingTerm',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition ="  (via LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
         foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["shipping_method_edit"])){
                        $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'shippingmethod/create&id='.$row['id'].'\',\'Edit Shipping Method\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["shipping_method_delete"])){
                   //     $div .=  ' <a href ="#" onclick="deleteShippingmethod('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>';
                    }
                    $rowData[]=array($m,
                        $row['via'],
                        $row['description'],
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                    array('id' => $row['id'],'code'=>'Edit Shipping Method', 'status' => $row->isActive));

                    
                
                    $m++;
                    
                }
        
        
        
//        
//        foreach ($model as $row)
//        {
//            $rowData[]=array($m,$row['via'],$row['description'],
//            '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'shippingmethod/create&id='.$row['id'].'\',\'Edit Shipping Method\')"><i class="fa fa-pencil"></i></button>
//            <a href ="#" onclick="deleteShippingmethod('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>',$row['isBaseShippingTerm']);
//            $m++;
//        }
        $data['data'] = $rowData;
        echo json_encode($data);
      
    }
    public function actionSaveShippingMethod()
    {
    $model = new MasShipping();
        if (isset($_POST['MasShipping']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasShipping']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $id= (int) @$_POST['MasShipping']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED'; 
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasShipping']['isBaseShippingTerm'] == "Y"){
                MasShipping::model()->updateAll(array( 'isBaseShippingTerm' => 'N' ), 'isBaseShippingTerm = "Y"' );
            }
            $model->attributes=$_POST['MasShipping'];
            $model->description=$_POST['MasShipping']['description'];
            
            if($model->save())
            {
                // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'SHIPPING_METHODS',
                    Yii::app()->user->id,
                    $audit_type,
                    " via : - {$model->via}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['shippingmethod_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
    public function actionDeleteShippingmethod()
    {
        $id = $_POST['id'];
        $model=new MasShipping();
        $del = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);
        // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'SHIPPING_METHODS',
                    Yii::app()->user->id,
                    $audit_type,
                    " via : - {$del->via}"
                );
        // end audit log
        echo "success";
    }    
    
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $via = $_POST['via'];
           $des = $_POST['des'];
           if($via != ''){
               $modelShipping = new MasShipping;
               $modelShipping->created_by = Yii::app()->user->id;
               $modelShipping->created_datetime =date('Y-m-d h:i:s');   
               $modelShipping->via = $via;
               $modelShipping->description = $des;
               $modelShipping->save(false);
           }
           $data  =  MasShipping::getShipping();
           if($from == 'quote'){
               $model = new Quotes;
               $field_name = 'shipping_by';
           }
           $model->$field_name = $modelShipping->id;
           $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Shipping By'));  
           $status=array("status" =>"success","drop" => $drop);    
           echo CJSON::encode($status);
            
         }
                 public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasShipping();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}