<?php

class SettingController extends Controller
{
	public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','ResetAgentPassword','UpdateAgentPassword'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    
	public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
	public function actionResetAgentPassword()
	{
		$this->render('reset_agent_password');
	}
	public function actionUpdateAgentPassword()
	{
	    $id = (int) $_POST['MasCompanySettings']['id'];
	    $agent_password = trim($_POST['MasCompanySettings']['agent_password']);
        $model = new MasCompanySettings();
        if ($id > 0 && $agent_password!='')
        {
            
            $model->updateByPk($id, array('agent_password' => $agent_password)); 
            $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;
            
        }
        else{
           $jsonData['status'] = 'failed'; 
        }
        
        echo CJSON::encode($jsonData);
          
    }

}