<?php

class CalendarController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetEvents', 'GetEventsAll','Calendar','hrcalendar','GetEvent'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    
     public function actionCalendar() {
        $this->render('calendar');
    }

    public function actionGetEventsAll() {
        $jasonevents = array(
            array(
                'title' => 'Event 1',
                'start' => '2018-02-01',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-02',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-03',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-04',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-05',
                'school' => '1',
                'type'=>'Notes'
            ),
        );
        echo CJSON::encode($jasonevents);
         Yii::app()->end();
    }

    public function actionGetEvents() {

        $start = Yii::app()->request->getParam('start');
        $end = Yii::app()->request->getParam('end');
        $filter_val = Yii::app()->request->getParam('filter_val');
        $activity_type = Yii::app()->request->getParam('activity_type');
        
        $jasonevents=$jasontaskevents=array();
        
        $condition = 't.isActive="Y"';
        if(((int) Yii::app()->user->havePermissionOn["activity_view_all"]) == 0){
                $condition.= ' AND (t.assigned_from="'.Yii::app()->user->id.'" OR t.assigned_to="'.Yii::app()->user->id.'")';
        }
        
        if ($start != '' && $end!="") {
                $condition .= ' AND (DATE(t.task_date_time) >="' . $start . '" AND DATE(t.task_date_time) <="' . $end . '")';
        }
        
        if($activity_type=='DI'){
            $condition .= ' AND added_from="DI"';
        }
        
        if($activity_type=='TA'){
            $condition .= ' AND added_from!="DI"';
        }
        
        $condition.= ' AND taskstatus.status_code!="C"';
        
        $model = new Activity();
        $modelActivity = $model->with('taskstatus','tasktype','customer')->findAll(array('condition' => $condition, 'order' => 't.task_date_time DESC'));
        
        $jo_task_list_color = MasColourScheme::model()->find(array('condition'=>'text_code="TA"'))->colour;
        $jo_dispute_list_color = MasColourScheme::model()->find(array('condition'=>'text_code="DI"'))->colour;
        foreach($modelActivity as $eachActivity){
            $type = $eachActivity->tasktype->type;
            $jasontaskevents['url'] = "javascript:void(0);";
            $jasontaskevents['date'] = $jasontaskevents['start'] = $jasontaskevents['end'] = date('Y-m-d', strtotime($eachActivity->task_date_time));
            $jasontaskevents['backgroundColor'] = ""; 
            $date = $eachActivity->task_date_time;
            $person = $eachActivity->assignedTo->fullname;
            if($eachActivity->added_from=="DI"){
                $label_activity="Dispute";
                $jasontaskevents['backgroundColor'] = $jo_dispute_list_color; 
            }
            else{
                 $label_activity="Task";
                $jasontaskevents['backgroundColor'] = $jo_task_list_color; 
            }
            $jasontaskevents['id'] = $eachActivity->id;
            $jasontaskevents['title'] = $label_activity." : ".$eachActivity->tasktype->type. " - " . $person;
            
            $jasontaskevents['description'] = "Added by - " . $eachActivity->assignedTo->fullname . '<br>
                '.$label_activity.' : ' . $eachActivity->notes . " <br/>                        
                Date/Time : " . $date;
            if ($eachActivity->customer_id > 0)
                $jasontaskevents['description'] .= '<br> Customer : ' . $eachActivity->customer->customer_name;
            $jasontaskevents['allDay'] = false;
            $jasontaskevents['type'] = $eachActivity->added_from;
            
            $jasontaskevents['customer_id']=(int) $eachActivity->customer_id;
            $jasonevents[] = $jasontaskevents;
        }
        
        //End Activity
        //Lead Start
        /*if(((int) Yii::app()->user->havePermissionOn["lead_view"]) || Yii::app()->user->authorised_user==1){
              $criteriaLead = new CDbCriteria;         
              //$criteriaLead->addCondition(' file.current_process_status="L"', 'AND');
              if(User::isSalesman()=='Y'){
                  $criteriaLead->addCondition(' t.lead_owner_id='.Yii::app()->user->id, 'AND');
              }
              //$criteriaLead->addCondition(' status!="C"', 'AND');
              //$criteriaLead->addCondition('(closing_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');          
              $modelLead = new Lead();        
              $arr_lead_details = $modelLead->with('file')->findAll($criteriaLead);      
              
              
                  foreach ($arr_lead_details as $eachLeads) {
                      $jasoneventsLead['type'] = "SLE";
                      $jasoneventsLead['backgroundColor'] = '#47D1FF'; //#6ad3ff';
                      $jasoneventsLead['url'] = "javascript:;";
                      $jasoneventsLead['date'] = $jasoneventsLead['start'] = date('Y-m-d', strtotime($eachLeads->closing_date));
                      $jasoneventsLead['id'] = $eachLeads->id;
                      $jasoneventsLead['title'] = "Lead - ".$eachLeads->id; //$type . " - " . $eachActivity->company->company_name;
                      $jasoneventsLead['description'] = "Lead: " . $eachLeads->id." / ".$eachLeads->file->file_title . '<br/> Lead Owner: ' . $eachLeads->leadowner->fullname . '<br/>Customer: ' . $eachLeads->customer->customer_name;
                      $jasoneventsLead['allDay'] = false;
                      $jasoneventsLead['customer_id'] = $eachLeads->customer_id;
                      $jasonevents[] = $jasoneventsLead;
                  }
        }
        //End Lead
       
        //Quotation Start
        if((int) Yii::app()->user->havePermissionOn['quotes_view'] || Yii::app()->user->authorised_user==1){
                $criteriaQtn = new CDbCriteria;
                $criteriaQtn->addCondition(' file.current_process_status="JO"', 'AND');
                 if(User::isSalesman()=='Y'){
                  $criteriaQtn->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND');
                }
                $criteriaQtn->addCondition('(qtn_validity BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');          
                $modelQuotes = new Quotes();
                $arr_quotation_details = $modelQuotes->with('file')->findAll($criteriaQtn);
                    foreach ($arr_quotation_details as $eachQuotation) {
                        $jasoneventsQtn['type'] = "SQE";
                        $jasoneventsQtn['backgroundColor'] = '#4256e7'; //#6ad3ff';
                        $jasoneventsQtn['url'] = "javascript:;";
                        $jasoneventsQtn['date'] = $jasoneventsQtn['start'] = date('Y-m-d', strtotime($eachQuotation->qtn_validity));
                        $jasoneventsQtn['id'] = $eachQuotation->id;
                        $jasoneventsQtn['title'] = "Quotation - ".$eachQuotation->id; //$type . " - " . $eachActivity->company->company_name;
                        $jasoneventsQtn['description'] = "Deal: " . $eachQuotation->id." / ".$eachQuotation->file_id . '<br/> Lead Owner: ' . $eachQuotation->leadowner->fullname . '<br/>Customer: ' . $eachQuotation->customer->customer_name;
                        $jasoneventsQtn['allDay'] = false;
                        $jasonevents[] = $jasoneventsQtn;
                    }
        }
        //End Quotation
       //echo $activity_name;*/
        //Start Order
        /*if((int) Yii::app()->user->havePermissionOn['job_order_view'] || Yii::app()->user->authorised_user==1){
                $criteria2 = new CDbCriteria;
               
                if(((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0){
                $condition.= ' AND (t.lead_owner_id=' . Yii::app()->user->id.')';
                }
                $criteria2->addCondition('(job_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');
                $modelOrder = new JobOrder();
                $arr_order_details = $modelOrder->with('file')->findAll($criteria2);
               
                foreach ($arr_order_details as $eachOrder) {
                    $jasoneventsOrder['type'] = "SOD";
                    $jasoneventsOrder['backgroundColor'] = '#3dd2c7'; //'#fced89';
                    $jasoneventsOrder['url'] = "javascript:void(0);";
                    $jasoneventsOrder['date'] = $jasonevents5['start'] = date('Y-m-d', strtotime($eachOrder->job_date));
                    $jasoneventsOrder['id'] = $eachOrder->id;
                    $jasoneventsOrder['title'] = "Job Order - ".$eachOrder->id; //$type . " - " . $eachActivity->company->company_name;
                    $jasoneventsOrder['description'] = "Job Order: " . $eachOrder->id." / ". $eachOrder->file_id . '<br/> Lead Owner: ' . $eachOrder->leadowner->fullname . '<br/>Customer:' . $eachOrder->customer->customer_name;
                    $jasoneventsOrder['allDay'] = false;
                    $jasonevents[] = $jasoneventsOrder;


                }
        }*/
        //End Order
        
        //Start Invoice
        /*if((int) Yii::app()->user->havePermissionOn['invoice_view'] || Yii::app()->user->authorised_user==1){
                $criteria2 = new CDbCriteria;
                 if(User::isSalesman()=='Y'){
                  $criteria2->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); 
                }
                $criteria2->addCondition('(invoice_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');
                $files = MasterFile::model()->with('invoices')->findAll($criteria2); // need to put condition here
                $modelInvoice = new Invoice();
                $arr_invoice_details = $modelInvoice->with('file')->findAll($criteria2);
                    foreach ($arr_invoice_details as $eachInvoice) {
                      $paymentTerm=$eachInvoice->paymentTerm->no_of_days;
                     
                        $inv_date = date('Y-m-d', strtotime($eachInvoice->invoice_date));
                      $jasoneventsInvoice['type'] = "SIP";
                      $jasoneventsInvoice['backgroundColor'] = '#8AC8F2'; //'#f4a1d2';
                      $jasoneventsInvoice['url'] = "javascript:void(0);";
                      $jasoneventsInvoice['date'] = $jasonevents3['start'] = $inv_date;
                      $jasoneventsInvoice['id'] = $eachInvoice->id;
                      $jasoneventsInvoice['title'] = "Invoice - ".$eachInvoice->id; //$type . " - " . $eachActivity->company->company_name;
                      $jasoneventsInvoice['hiring']=$eachInvoice->is_hiring_invoice;
                      $jasoneventsInvoice['description'] = "Invoice: " . $eachInvoice->file_id." / ".$eachInvoice->invoice_no  . '<br/> Lead Owner: ' . $eachInvoice->file->leadowner->fullname . '<br/>Customer: ' . $eachInvoice->customer->customer_name;
                      $jasoneventsInvoice['allDay'] = false;
                      $jasonevents[] = $jasoneventsInvoice;
            }
        }*/
        //End Invoice
        
        echo CJSON::encode($jasonevents);
        Yii::app()->end();
    }
    public function actionHrcalendar() {
        $this->render('hr_index');
    }
    public function actionGetEvent() {      
        $model_leave_details= EmployeeLeaveDetail::model()->findAll();
            foreach ($model_leave_details as $leavedetail) {
                $leave_start_date='';
                $leave_end_date='';
                  if ($leavedetail->leave_start_date!= '' && $leavedetail->leave_start_date!= '0000-00-00') {
                      $leave_start_date =date("d/m/Y", strtotime($leavedetail->leave_start_date));;
                  }
                  if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                      $leave_end_date =date("d/m/Y", strtotime($leavedetail->leave_end_date));;
                  }
                $leave['type'] = "Leave";
                $leave['backgroundColor'] = '#FF6347'; //'#f4a1d2';
                $leave['url'] = "javascript:void(0);";
                $leave['date'] = $leave['start'] = $leavedetail->leave_start_date;
                $leave['end'] = $leavedetail->leave_end_date;
                $leave['title'] =ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))). '-' .$leavedetail->leavetype->leave_name.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status); 
                $leave['description'] = ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))).' on '.$leavedetail->leavetype->leave_name.' from '.$leave_start_date.' to '.$leave_end_date.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status);
                $leave['allDay'] = false;


                $jsonevents[] = $leave;
            }
        $model_notification= CalendarNotification::model()->findAll();
            foreach ($model_notification as $detail) {
                $start_date='';
                $end_date='';
                  if ($detail->start_date!= '' && $detail->start_date!= '0000-00-00') {
                      $start_date =date("d/m/Y", strtotime($detail->start_date));;
                  }
                  if ($detail->end_date != '' && $detail->end_date != '0000-00-00') {
                      $end_date =date("d/m/Y", strtotime($detail->end_date));;
                  }
                $notify['type'] = "Leave";
                $notify['backgroundColor'] = '#ff8c00'; //'#f4a1d2';
                $notify['url'] = "javascript:void(0);";
                $notify['date'] = $notify['start'] = $detail->start_date;
                $notify['end'] = $detail->end_date;
                $notify['title'] =$start_date.'-'.$end_date; 
                $notify['description'] =$detail->notification;
                $notify['allDay'] = false;
                $jsonevents[] = $notify;
            }
        echo CJSON::encode($jsonevents);
        Yii::app()->end();
    }
}
