<?php

class ApiMailhistoryController extends Controller
{

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'SaveMailhistory','login','MailHistoryList','MailAddress'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    
    public function beforeAction($action) {
          $this->ChangeDB();
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;
        return parent::beforeAction($action);
    }
    
   public function actionSaveMailhistory() {
                $input = file_get_contents('php://input');
                $variables = json_decode($input, true);
               
            $valid=true;
          $arr_items = $variables['items'];
            $p=0;
            if(!empty($arr_items)){			
                foreach($arr_items as $item){
                      if ($item['job_id'] > 0) {
                        $modelMailHistory[$p] = new MailHistory();
                        $modelMailHistory[$p]->job_id = $item['job_id'];
                        $modelMailHistory[$p]->customer_id = $item['customer_id'];
                        $modelMailHistory[$p]->mail_date = $item['mail_date'];
                        $modelMailHistory[$p]->status = $item['status'];
                       
                        
                        $valid = $modelMailHistory[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }
             if($valid){
                 if (!empty($modelMailHistory)) {
                        foreach ($modelMailHistory as $eachModel) {
                            $eachModel->save();
                        }
                    }       
                    $data['status'] = 'success';
                     header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
             }else{
                $data['status'] = 'failed';
                if ($modelMailHistory[0]->job_id > 0){
                   $error1 = json_decode(CActiveForm::validateTabular($modelMailHistory, '', false), true);
                }
         
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
             echo json_encode($data);
   }
    public function actionMailHistoryList() {
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);

            //    if ($userModel->id > 0) {
             $input = file_get_contents('php://input');
             error_log($input);
            $variables = json_decode($input, true);
      
        $mail_date= $variables['mail_date'];
       
            $condition = "1=1";
            if ($mail_date != "") {



            $mail_date = str_replace('/', '-', $mail_date);
            $mail_date = date("Y-m-d", strtotime($mail_date));
            $condition .= ' AND (DATE(t.mail_date) >="' .$mail_date . '" AND DATE(t.mail_date) <="' . $mail_date . '")';
        }
       
           $model = new MailHistory();
            $model = $model->findAll(array('condition' => $condition,'order' =>'t.id desc'));

            $m = 1;
            foreach ($model as $key => $row) {
                $maildate= date("d/m/Y", strtotime($row['mail_date']));
               

                $data[] = [
                    "SI No" => $m,
                    "job_id" => $row['job_id'],
                    "customer" => $row['customer']['customer_name'],
                    "customer_mail" => $row['customer']['customer_email_id'],
                    "status" => $row['status'],
                    "maildate" => $maildate,
                   
                ];
                $m++;
            }

            $data = array('status' => "success", "items" => $data);
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            /*   } else {
              header("HTTP/1.1 401 Unauthorized");
              header('Content-Type: application/json');
              $data = array('status' => "failed", "msg" => "Unauthorized user");
              } */
            if (empty($data)) {
                $data[] = array('msg' => "No Data Available");
            }
        } catch (Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }
    public function actionMailAddress() {
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);

            //    if ($userModel->id > 0) {
            $email_address ="tracking@infinitylogisticsme.com";
            $email_name = "Tracking | Infinity Logistics";
            $count ="A";
             
           $data = array('status' => "success", "data" => ["email_address" => $email_address, "email_name" => $email_name,'count' =>$count]);
          
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            /*   } else {
              header("HTTP/1.1 401 Unauthorized");
              header('Content-Type: application/json');
              $data = array('status' => "failed", "msg" => "Unauthorized user");
              } */
           
        } catch (Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }
        
}