<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        <p>Invoices</p>
    <div class="pull-right">
            <div class="filter_details">

            <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From Date:</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
            ?>
                <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To Date :</label>
                            <?php echo $to_date ?>
                        </div>

                    <?php
                }
            ?>
                <?php
                if($type !=''){
                    ?>
                        <div class="filter-item">
                            <label>Type :</label>
                            <?php echo ($type=='1')?'EntryInvoice':'ExitInvoice'; ?>
                        </div>

                    <?php
                }
            ?>
                <?php
                if($customer_id >0){
                    ?>
                        <div class="filter-item">
                            <label>Customer :</label>
                            <?php echo Customer::model()->findByPk($customer_id)->customer_name; ?>
                        </div>

                    <?php
                }
            ?>
            </div>
    </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">


            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Sl No.</th>
                        <th>Type</th>
                        <th>Invoice No.</th>
                        <th>Invoice Date</th>
                        <th>Reference#</th>
                        <th>Customer</th>
                        <th>Manifest No</th>
                        <th>Truck No</th>
                        <th>Value</th>

                    </tr>
                </thead>
                <tbody>
               <?php
                    $condition_entry="WHERE 1=1 ";
                    $condition_exit="WHERE 1=1 ";
                    if ($from_date != '') {
                        $form_from_date = str_replace('/', '-', $from_date);
                        $form_from_date = date('Y-m-d', strtotime($form_from_date));
                        $condition_entry .= ' AND entry.invoice_date >="'.$form_from_date.'"';
                        $condition_exit .= ' AND exitinv.invoice_date >="'.$form_from_date.'"';
                    }
                    if ($to_date != '') {
                        $form_to_date = str_replace('/', '-', $to_date);
                        $form_to_date = date('Y-m-d', strtotime($form_to_date));
                        $condition_entry .= ' AND entry.invoice_date <="'.$form_to_date.'"';
                        $condition_exit .= ' AND exitinv.invoice_date <="'.$form_to_date.'"';

                    }
                    if($customer_id!="")
                    {
                            $condition_entry.=" AND entry.customer_id=".$customer_id;
                            $condition_exit.=" AND exitinv.customer_id=".$customer_id;
                    }
                    $SQL_ENTRY = "SELECT  entry.id AS invoice_id,'Entry' AS type,invoice_date,total_vat_amount,customer_name,customer_id,grand_total,shipment_reference,
            				(SELECT GROUP_CONCAT( manifest.manifest_no ) FROM crm_entry_invoice_manifest_no AS manifest WHERE entry.id=entry_invoice_id) AS manifest_no,
            				(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_entry_invoice_truck_no AS truck WHERE entry.id=entry_invoice_id) AS truck_no
							FROM `crm_entry_invoice` AS entry
            				INNER JOIN crm_customer AS customer ON entry.customer_id=customer.id ".$condition_entry." GROUP BY entry.id ";

                    $SQL_EXIT=" SELECT  exitinv.id AS invoice_id,'Exit' AS type,invoice_date,total_vat_amount,customer_name,customer_id,grand_total,shipment_reference,
							(SELECT GROUP_CONCAT( manifest.manifest_no ) FROM crm_exit_invoice_manifest_no AS manifest WHERE exitinv.id=exit_invoice_id) AS manifest_no,
							(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_exit_invoice_truck_no AS truck   WHERE exitinv.id=exit_invoice_id) AS truck_no
							FROM `crm_exit_invoice` AS exitinv
							INNER JOIN crm_customer AS customer ON exitinv.customer_id=customer.id ".$condition_exit." GROUP BY exitinv.id ";


                    if($type!="")
                    {

                            if($type == 1)
                            {
                                    $SQL=$SQL_ENTRY;
                            }
                            else if($type == 2)
                            {
                                    $SQL=$SQL_EXIT;
                            }

                    }
                    else
                    {
                            $SQL=$SQL_ENTRY." UNION ALL ".$SQL_EXIT;
                    }


                    $arr_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();
			?>
                    <input type="hidden" id="inv_type" name="type" value="<?php echo $type; ?>">
                    <input type="hidden" id="inv_from_date" name="from_date" value="<?php echo $form_from_date; ?>">
                    <input type="hidden" id="inv_to_date" name="to_date" value="<?php echo $form_to_date; ?>">
                    <input type="hidden" id="inv_customer_id" name="customer_id" value="<?php echo $customer_id; ?>">
                    <?php
                    $sno=1;
                    foreach ($arr_invoice_details as $i => $model) {

                        ?>

                    <tr>
                            <td><?php echo $sno++; ?></td>
                            <td><?php echo $model['type']; ?></td>
                            <td><?php echo $model['invoice_id']; ?></td>
                            <td><?php echo date("d/m/Y",strtotime($model['invoice_date']));; ?></td>
                            <td><?php echo $model['shipment_reference']; ?></td>
                            <td><?php echo $model['customer_name']; ?></td>
                            <td><?php echo $model['manifest_no']; ?></td>
                            <td><?php echo $model['truck_no']; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['grand_total'],""); ?></td>

                            </tr>
                            <?php

                        }

					 ?>
					            </tbody>
            </table>

	    <div class="space"></div>
                    <div class="col-6">Created By :
                            <span><?php echo Yii::app()->user->fullname; ?></span> </div>
                    <div class="col-6 cell-right">Created On :
                            <span><?php
                                                        $h = "4";// Hour for time zone goes here e.g. +7 or -4, just remove the + or -
$hm = $h * 60;
$ms = $hm * 60;
$gmdate = gmdate("m/d/Y g:i:s A", time()+($ms));
echo $gmdate;
                           // echo date('Y/m/d H:i:s') ?></span> </div>
						   <br>


           <div class="btn-wrap text-center">
                <button type="button" class="btn btn-theme" onclick="excel();">Export Excel</button>
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excel", "function excel()
{
  var json_param = {
    type: $('#inv_type').val(),
    from_date: $('#inv_from_date').val(),
    to_date: $('#inv_to_date').val(),
    customer_name: $('#inv_customer_id').val(),
  }
  var url = $('#liveSite').val() + 'index.php?r=excel/PrintInvoiceReport&' + jQuery.param(json_param);
  window.open(url, '_blank');
}
", CClientScript::POS_HEAD);