<div class="panel">
    <div class="panel-heading panel-theame">
        <p>List of Customers</p>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <input type="hidden" id="customer_name" name="customer_name" value="<?php echo $customer_name; ?>">
            <input type="hidden" id="country" name="country" value="<?php echo $country; ?>">

            <table id="tbl_student_table" class="table table-fixed table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Credit Limit</th>
                        <th>Address</th>
                        <th>City</th>
                        <th>Postal Code</th>
                        <th>State</th>
                        <th>Country</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Set the condition for the query
                    $condition = '1=1';

                    // Add customer name filter if it's provided
                    if ($customer_name != '') {
                        $condition .= ' AND t.customer_name LIKE "%' . $customer_name . '%"';
                    }

                    // Add country filter if it's provided
                    if ($country != '') {
                        $condition .= ' AND t.country = "' . $country . '"';
                    }

                    // Get customers based on the condition
                    $model_customer = Customer::model()->with('country')->findAll(array(
                        'condition' => $condition,
                        'order' => 'customer_name ASC'
                    ));

                    // Loop through the customers and display them in the table
                    foreach ($model_customer as $i => $model) {
                    ?>
                        <tr>
                            <td><?php echo $i + 1; ?></td>
                            <td><?php echo $model->customer_name; ?></td>
                            <td class="text-right"><?php echo $model->credit_limit; ?></td>
                            <td><?php echo $model->address; ?></td>
                            <td><?php echo $model->city; ?></td>
                            <td><?php echo $model->po_box; ?></td>
                            <td><?php echo $model->state; ?></td>
                            <td><?php echo $model['country_details']['country_name']; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

            <br>

            <div class="btn-wrap text-center">
                <?php
                // Uncomment the following line if you need to allow exporting to PDF
                // echo CHtml::link('Export PDF', array('reports/PrintCustomerReportPDF', 'customer_name' => $customer_name, 'country' => $country), array('title' => 'Print Customer List', 'target' => '_blank', 'class' => 'btn btn-theme'));
                ?>
                <!-- <button type="button" class="btn btn-theme" onclick="excelCustomerList();">Export Excel</button> -->
            </div>
        </div>
    </div>
</div>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("excelCustomerList", "
    function excelCustomerList() {
        var url = '" . Yii::app()->createUrl('reports/PrintCustomerExcel') . "';
        var customer_name = $('#customer_name').val();
        var country = $('#country').val();
        window.open($('#liveSite').val() + 'index.php?r=reports/PrintCustomerExcel&customer_name=' + customer_name + '&country=' + country, '_blank');
    }
", CClientScript::POS_HEAD);
?>
