<!DOCTYPE html>
<html>

    <head>
        <title>Day Book Report</title>
    </head>

    <body>
        <div class="heading">
            <div class="logo col-6">
                 <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>

        </div>
        <div class="clearfix"></div>
        <div class="title">
            <div class="col-6">
                <div style="height: 10px;"></div>
            </div>
            <div class="col-6 text-right">
                <h1>Day Book Report</h1>
                <div class="pull-right">
                    <div class="filter_details">
                        
                    </div>
            </div>
            <div class="details-box">
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="panel">
        <div class="panel-heading panel-theme clearfix report-head">

        </div>

        <div class="panel-body">
            <div class="table-responsive">

                <table id="tbl_lead_table" class="table table-fixed table-bordered table-primary dataTable">
                    <thead>
                        <tr>
                            <th align="left">&nbsp;Type</th>
                            <th align="left">&nbsp;File No</th>
                            <th align="left">&nbsp;No</th>
                            <th align="left">&nbsp;Customer/Vendor.</th>
                            <th>Currency</th>
                            <th>Amount</th>
                            <th>Amount (BC)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // $day_book_type						=	$_POST['day_book_type'];
                        //echo $day_book_type;

                        $arr_day_book_start_date = explode("/", $day_book_start_date);

                        $day_book_start_date = $arr_day_book_start_date[2] . "-" . $arr_day_book_start_date[1] . "-" . $arr_day_book_start_date[0];


                        $day_book_end_date_time_stamp = strtotime($day_book_start_date . " +1 day");
                        $day_book_end_date = strftime('%Y-%m-%d', $day_book_end_date_time_stamp);


                        $arr_day_book_report = array();
                        $query = "";

                        	$condition_order="";
		if ($day_book_start_date!="" && $day_book_end_date!="")
		$condition_order.=" AND O.order_date >= '".$day_book_start_date."' AND O.order_date < '".$day_book_end_date."'";
		
		
		$condition_invoice		=	"WHERE I.isActive='Y'";
		if ($day_book_start_date!="" && $day_book_end_date!="")
		$condition_invoice.=" AND I.invoice_date >= '".$day_book_start_date."' AND I.invoice_date < '".$day_book_end_date."'";
		
		$condition_credit_note		=	"WHERE CN.isActive='Y'";
		if ($day_book_start_date!="" && $day_book_end_date!="")
		$condition_credit_note.=" AND CN.credit_date >= '".$day_book_start_date."' AND CN.credit_date < '".$day_book_end_date."'";
		
		
	
		$condition_purchase_invoice		=	"";
		if ($day_book_start_date!="" && $day_book_end_date!="")
		$condition_purchase_invoice.=" WHERE PI.purchase_order_date >= '".$day_book_start_date."' AND PI.purchase_order_date < '".$day_book_end_date."'";
			
		$condition_debit_note		=	"WHERE DN.isActive='Y'";
		if ($day_book_start_date!="" && $day_book_end_date!="")
		$condition_debit_note.=" AND DN.debited_date >= '".$day_book_start_date."' AND DN.debited_date < '".$day_book_end_date."'"; 
	
	
	      if($day_book_type=='I')
		{   
        	$query= "SELECT 'Invoice' AS type,file_id,O.id AS action_id,customer_name,currency_code,O.exchange_rate,grand_total AS amount FROM {{direct_order}} AS O 
        			INNER JOIN {{master_file}} AS MF ON O.file_id=MF.id 
        			INNER JOIN {{customer}} AS CP ON O.customer_id=CP.id 
        			INNER JOIN {{mas_currency}} AS CR ON O.currency_id=CR.id ".$condition_order;
		} 
		elseif($day_book_type=='CN')
		{        
			$query.= "SELECT 'Credit Note' AS type,file_id,CN.id AS action_id,customer_name,currency_code,CN.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{creditnote_item}} AS CI WHERE CI.creditnote_id=CN.id) AS amount FROM {{creditnote}} AS CN 
        			INNER JOIN {{master_file}} AS MF ON CN.file_id=MF.id 
        			INNER JOIN {{customer}} AS CP ON CN.customer_id=CP.id 
        			LEFT JOIN {{mas_currency}} AS CR ON CN.currency_id=CR.id ".$condition_credit_note;
		}
		elseif($day_book_type=='PI')
		{        
			$query= "SELECT 'Purchase Invoice' AS type,file_id,PI.id AS action_id,vendor_name AS customer_name,currency_code,PI.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{direct_purchase_order_items}} AS PII WHERE PII.purchase_order_id=PI.id) AS amount FROM {{direct_purchase_order_general}} AS PI 
					INNER JOIN {{master_file}} AS MF ON PI.file_id=MF.id 
        			INNER JOIN {{vendor}} AS CP ON PI.vendor_id=CP.id 
        			INNER JOIN {{mas_currency}} AS CR ON PI.currency_id=CR.id ".$condition_purchase_invoice;
		}
	    elseif($day_book_type=='DN')
		{        
				$query= "SELECT 'Debit Note' AS type,file_id,DN.id AS action_id,vendor_name AS customer_name,currency_code,DN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{purchasing_debit_note_item}} AS PCI WHERE PCI.purchasing_debitnote_id=DN.id) AS amount FROM {{purchasing_debit_note}} AS DN 
        			INNER JOIN {{master_file}} AS MF ON DN.file_id=MF.id 
        			INNER JOIN {{vendor}} AS CP ON DN.vendor_id=CP.id 
        			LEFT JOIN {{mas_currency}} AS CR ON DN.currency_id=CR.id ".$condition_debit_note;
		}
		else
		{ 
			
			$query= "SELECT 'Invoice' AS type,file_id,O.id AS action_id,customer_name,currency_code,O.exchange_rate,grand_total AS amount FROM {{direct_order}} AS O 
        			INNER JOIN {{master_file}} AS MF ON O.file_id=MF.id 
        			INNER JOIN {{customer}} AS CP ON O.customer_id=CP.id 
        			INNER JOIN {{mas_currency}} AS CR ON O.currency_id=CR.id ".$condition_order;
        			
        			
			
			$query.= " UNION ";
			
		    
			$query.= "SELECT 'Credit Note' AS type,file_id,CN.id AS action_id,customer_name,currency_code,CN.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{creditnote_item}} AS CI WHERE CI.creditnote_id=CN.id) AS amount FROM {{creditnote}} AS CN 
        			INNER JOIN {{master_file}} AS MF ON CN.file_id=MF.id 
        			INNER JOIN {{customer}} AS CP ON CN.customer_id=CP.id 
        			LEFT JOIN {{mas_currency}} AS CR ON CN.currency_id=CR.id ".$condition_credit_note;
			
			
			$query.= " UNION ";
			
			
			$query.= "SELECT 'Purchase Invoice' AS type,file_id,PI.id AS action_id,vendor_name AS customer_name,currency_code,PI.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{direct_purchase_order_items}} AS PII WHERE PII.purchase_order_id=PI.id) AS amount FROM {{direct_purchase_order_general}} AS PI 
					INNER JOIN {{master_file}} AS MF ON PI.file_id=MF.id 
        			INNER JOIN {{vendor}} AS CP ON PI.vendor_id=CP.id 
        			INNER JOIN {{mas_currency}} AS CR ON PI.currency_id=CR.id ".$condition_purchase_invoice;
					
					
			
			$query.= " UNION ";			
					
			$query.= "SELECT 'Debit Note' AS type,file_id,DN.id AS action_id,vendor_name AS customer_name,currency_code,DN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{purchasing_debit_note_item}} AS PCI WHERE PCI.purchasing_debitnote_id=DN.id) AS amount FROM {{purchasing_debit_note}} AS DN 
        			INNER JOIN {{master_file}} AS MF ON DN.file_id=MF.id 
        			INNER JOIN {{vendor}} AS CP ON DN.vendor_id=CP.id 
        			LEFT JOIN {{mas_currency}} AS CR ON DN.currency_id=CR.id ".$condition_debit_note;
					
			
		 }
			




                        //echo $query;
                        //die();






                        $arr_day_book_report = Yii::app()->db->createCommand($query)->queryAll();


                        //print_r($arr_day_book_report);
                        //die;

                        foreach ($arr_day_book_report as $eachItem) {
                            $net_amount = $eachItem['amount'];
                            if ($eachItem['exchange_rate'] != '0.00' && $eachItem['exchange_rate'] != 0)
                                $net_amount = $eachItem['amount'] * $eachItem['exchange_rate'];

                            $class = $class == "odd" ? "even" : "odd";
                            ?>

                            <tr class = "' . $class . '"> 
                                <td ><?= $eachItem['type'] ?></td>
                                <td class = "cell-left"><?= $eachItem['file_id'] ?></td>
                                <td class = "cell-left"><?= $eachItem['action_id'] ?></td> 
                                <td class = "cell-left"><?= $eachItem['customer_name'] ?></td>
                                <td><?= $eachItem['currency_code'] ?></td>    
                                <td class = "cell-right"><?php echo Yii::app()->numberFormatter->formatCurrency($eachItem['amount'], ""); ?></td>
                                <td class = "cell-right"><?php echo Yii::app()->numberFormatter->formatCurrency($net_amount, ""); ?></td>
                            </tr>

                            <?php
                            $total +=$net_amount;
                            $cnt++;
                        }
                        ?>
                    </tbody>
                </table>
                
                
            </div>
        </div>
    </div>
    
    
    <htmlpagefooter name="myfooter">

    <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
        <div style="binvoice-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="text-align:center;width:100%">This report is auto generated by Bluesky ERP on
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y') . " " . date("h:i:sa");
                ?>
             </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div></div>
    <label>

    </label>
</htmlpagefooter>
<sethtmlpagefooter name="myfooter" page="all" value="on" />
</body>
</html>


