<html lang="en">
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
<style type="text/css">
@media print {
	*{
		box-sizing: border-box;
	}
	body{
		margin: 0;
		padding: 15px;
		font-family: initial;
	}
	.container{
		max-width: 1020px;
		margin: 0 auto;
	}
	.heading{
		width: 100%;
		float: left;
		text-align: left;
	}
	.heading-img{
		float: right;
		max-width: 200px;
	}
	.heading h4{
		margin: 8px 0;
		float: left;
		font-size: 22px;
	}
	.heading small{
		float: left;
		clear: both;
		font-size: 12px;
		font-weight: 300;
	}
	.tittle{
		width: 100%;
		margin:10px 0;
		float: left;
		text-align: center;
	}
	.tittle h6{
		border-bottom:2px solid #000;
		width: 130px;
		max-width: 350px;
		font-size: 16px;
		margin: 10px auto;
	}
	.date{
		width: 30%;
		margin-left: 70%;
		float: left;
		font-size: 12px;
    	font-weight: 600;
	}
	.date span{
		width: 150px;
		display: inline-block;
	}
	.span1{
		width: 55px;
		display: inline-block;
		float: left;
	}

	.span2{
		width: 33%;
		display: inline-block;
		float: right;
	}

	.details{
		width: 100%;
		float: left;
    	font-size: 12px;
	}
	table{
		border-collapse: collapse;
		border-width: 1px;
		float: left;
		width: 100%;
		margin-top:5px;
		font-size: 12px;
	}
	td,th{
		padding: 5px;
		border: 1px solid #000;
		font-size: 12px;
	}
	th{
	}
	.txt-right{
		text-align: right !important;
	}
	.ul-top{
		border-top: 2px solid #000 !important;
		font-weight: 900;
	}
	.col-4{
		width: 33%;
		float:left;
		text-align: center;
		font-size: 12px;
	}
	.space{
		margin: 15px 0;
		width: 100%;
		float: left;
	}
	.col{
		padding: 0 5px;
		border-top: 2px solid #000;
		font-weight: 600;
		font-size: 12px;
	}
	.dot-ul{
		width: 100%;
		height: 1px !important;
		border: 1px dashed #000;
	}
	.tbl-2{
		width: 100%;
	}
	.tbl-2 td{
		border-left: none;
		border-right: none;
		border-bottom:none;
	}
	.bdr-tn{
		border-top: none;
	}
	.tbl-2 th{
		border-left: none;
		border-right: none;
	}
	.clear{
		clear: both;
	}
	.spacer{
		height: 85px;
		width: 100%;
	}
	.text-bold{
		font-weight:900;
	}
}
</style>
<?php 
/***
 * GL Report 
 * Author Jo~
 * @param $opening_bal_debit is account debit opening balance
 * @param $opening_bal_credit is account credit banace
 * @param $account_opening_balance account opeing balance 
 * @param $total_opening is the total opeing
 */
$opening_bal_debit = $opening_bal_credit =  $account_opening_balance = $total_opening = 0;
$condition_for_opening_balanace = '1=1';
$condition = 'isAllocated="Y" AND date BETWEEN "'.$rp_from_date.'" AND "'.$rp_to_date.'"';
$current_year = date('Y-01-01');
if($account > 0)
    $ACCOUNT = FinAccounts::model()->findBypk($account);
if($subledger > 0)
    $SUBLEDGER = Subledger::model()->findBypk($subledger);
/**
 * Opening Balance
 */
if(!empty($ACCOUNT)){
    $condition .= ' AND account_id = '.$account;
    /**
     * IF -  Account is Expense Or Income
     * ELSE = Account is Liability or Asset
     */
    if($ACCOUNT->account_type=="E" || $ACCOUNT->account_type=="I")
    {
        $condition_for_opening_balanace .= ' AND account_id ='.$account.' AND isAllocated="Y" AND date BETWEEN "'.$current_year.'" AND "'.$rp_from_date.'"';
    }else{
        $condition_for_opening_balanace .= ' AND account_id ='.$account.' AND isAllocated="Y" AND date < "'.$rp_from_date.'"';
    }
    /**
     * Account opening balance
     */
     if($ACCOUNT->opening_bal_type == 2){
            $opening_bal_debit = (float) $ACCOUNT->opening_bal;
     }else if($ACCOUNT->opening_bal_type == 1){
            $opening_bal_credit = (float) $ACCOUNT->opening_bal;
     }
     if($ACCOUNT->account_type=='A' || $ACCOUNT->account_type=='E')
     {
         $account_opening_balance = $opening_bal_debit - $opening_bal_credit;
     }else{
         $account_opening_balance = $opening_bal_credit - $opening_bal_debit;
     }
}else{
    $condition_for_opening_balanace .= ' AND isAllocated="Y" AND date < "'.$rp_from_date.'"';
}
/**
 * Subledger
 */
if(!empty($SUBLEDGER)){
    $condition_for_opening_balanace  .= ' AND subledger = '.$subledger.' ';
    $condition .= ' AND subledger = '.$subledger.' ';
}
$total_debit = Yii::app()->db->createCommand('SELECT SUM(debit) FROM crm_fin_general_ledger WHERE '.$condition_for_opening_balanace.' ')->queryScalar();
$total_credit = Yii::app()->db->createCommand('SELECT SUM(credit) FROM crm_fin_general_ledger WHERE '.$condition_for_opening_balanace.' ')->queryScalar();
/*
 * Total Opening Balance
 */
$total_opening = ($account_opening_balance+($total_debit - $total_credit));
/**
 * Getting Vouchers
 */
$allVouchers = FinGeneralLedger::model()->findAll(array('condition' => $condition));
?>
</head>
<body>
	<div class="container">
            <div class="heading tittle">
                    <div><h2><?php echo Yii::app()->user->master_company_name;?></h2></div>
            </div>
	</div>
        <div class="tittle"><h6>GL Transaction</h6></div>
        <div class="container-fluid">
        <div class="col-md-12">
                <div class="col-md-9"></div>
                <div class="col-md-3">
                            <div class="span2">
                                <b>Date From</b>
                            : <?php echo date('d/m/Y',strtotime($rp_from_date)); ?></div><br>
                            <div class="span2">
                                <b>Date To</b>
                            : <?php echo date("d/m/Y", strtotime($rp_to_date)); ?></div><br>
                        </div>

        </div>
        </div>

               
		<div class="details">
                    <?php if(!empty($ACCOUNT)):?>
                        <b>Account : <?php echo $ACCOUNT->description; ?></b><br>
                    <?php endif; ?>
                    <?php if(!empty($SUBLEDGER)):?>
                        <b>Subledger : <?php echo $SUBLEDGER->description; ?></b><br>
                    <?php endif; ?>
                        <?php 
                            if($total_opening < 0)
                                $debit_or_credit = 'Cr';
                            else
                                $debit_or_credit = 'Dr';
                        ?>
                        <b>Opening Balance : <?php echo number_format(abs($total_opening), 2, '.', ''); echo $debit_or_credit; ?></b>
		</div>
               
                <div class="clear"></div>
		<table class="tbl-2">
			<thead>
				<tr>
					<th>Date</th>
					<th>Voucher #</th>
					<th>Narration</th>
					<th>Debit</th>
					<th>Credit</th>
					<th>balance</th>
				</tr>
			</thead>
			<tbody>
                            <?php 
                            $debit_total=0;
                            $credit_total=0;
                            $balance = $total_opening;
                            foreach ($allVouchers as $row)
                            {
                               $balance += ($row->db_entered-$row->cr_entered);
                               if($balance < 0)
                                    $debit_or_credit = 'Cr';
                                else
                                    $debit_or_credit = 'Dr';
                                ?>
				<tr>
					<td class="bdr-tn"><?php echo date('d/m/Y',strtotime($row->date)); ?></td>
					<td class="bdr-tn"><?php echo $row->voucher_no; ?></td>
					<td class="bdr-tn"><?php echo $row->narration; ?></td>
					<td class="txt-right bdr-tn"><?php echo Yii::app()->numberFormatter->formatCurrency($row->db_entered, ""); ?></td>
					<td class="txt-right bdr-tn"><?php echo Yii::app()->numberFormatter->formatCurrency($row->cr_entered, ""); ?></td>
                                        <td class="txt-right bdr-tn"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($balance), ""); ?> <?= $debit_or_credit ?></td>
				</tr>
				<?php
                                $debit_total+=$row->db_entered;
                                $credit_total+=$row->cr_entered;
                                } ?>
				<tr>
					<td class="bdr-tn"></td>
					<td class="bdr-tn"></td>
					<td class="bdr-tn"></td>
                                        <td class="ul-top text-bold txt-right"><h4><?php echo Yii::app()->numberFormatter->formatCurrency($debit_total, ""); ?></h4></td>
					<td class="ul-top text-bold txt-right"><h4><?php echo Yii::app()->numberFormatter->formatCurrency($credit_total, ""); ?></h4></td>
                                        <td class="bdr-tn"></td>
				</tr>
			</tbody>
		</table>
		<div class="space"></div>
		<div class="spacer"></div>
		<div class="col-4"><div class="col" style="width:67px;float:left;" ><label>Prepared By</label></div></div>
		<div class="col-4" style="width:21%;margin:0 11%"><div class="col" style="width:70px;float:none;" ><label>Approved By</label></div></div>
		<div class="col-4"><div class="col" style="width:67px;float:right;" ><label>Received By</label></div></div>
		<div class="clear"></div><br>
<!-- 		Note : Payment by Cheques accounted only after the realisation of the Cheques.
		<div class="dot-ul"></div> -->
		<div class="clear"></div>
	</div>
        <!--mpdf
        <htmlpagefooter name="myfooter">
            <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
                <div style="text-align:left;width:50%;float:left">Printed on <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?> by <?php $use=User::model()->findByPk(Yii::app()->user->id); echo $use->username; ?></div>
                <div style="text-align:right;width:50%;float:left">Page {PAGENO} of {nb} </div>
            </div>
        </htmlpagefooter>
        <sethtmlpagefooter name="myfooter" page="all" value="on" />
        mpdf-->
</body>
