<?php 
$startDate = date("Y-m-d", strtotime(str_replace('/', '-',$startDate)));
$closingDate =  date("Y-m-d", strtotime(str_replace('/', '-',$closingDate)));     
if($vendor_id == ''){
    
    $conPO =  'order_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'" AND stock_grand_total > 0';
    $conMR =  'mrv_receipt_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'"';
    $conPI =  'invoice_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'" AND grand_total > 0';
}else{
   
    $conPO =  'vendor_id = '.$vendor_id.' AND order_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'" AND stock_grand_total > 0';
    $conMR =  'vendor_id = '.$vendor_id.' AND mrv_receipt_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'"';
    $conPI =  'vendor_id = '.$vendor_id.' AND invoice_date BETWEEN "'.$startDate.'" AND "'.$closingDate.'" AND grand_total > 0';
}
    
    $POData =  PurchasingOrder::model()->findAll(array('condition' =>$conPO));  
    $MRData =  PurchasingMaterialreceipt::model()->findAll(array('condition' =>$conMR));  
    $PIData =  PurchasingInvoice::model()->findAll(array('condition' =>$conPI));
    
?>

<section class="box-group accordion-parent clearfix" id="accordion">
    <div class="panel clearfix no-panel">
      <div class="col-sm-12">
        <a class="cards-title" href="#order-accordion" data-toggle="collapse" data-parent="#accordion">
          <i class="fa fa-line-chart" aria-hidden="true"></i>  ORDER
        </a>
      </div>
        <div class="clearfix"></div>
        <section id="order-accordion" class="collapse clearfix">
            <div class="clearfix"><br></div>
            <div class="clearfix">
                <div class="col-xs-12">
                     <div class="table-responsive box-table">
                          <table class="table table-bordered table-theme personal-task ">
                                <tr>
                                    <th>Order No.</th>
                                    <th>Order Date</th>
                                    <th>Req. Date</th>
                                    <th>Vendor</th>
                                    <th>Value</th>
                                </tr>
                             
                                <?php if(!empty($POData)){?>
                                <?php foreach ($POData as $row){?>
                                <tr>
                                    <td><?php echo $row->id;?></td>
                                    <td><?php echo date("d/m/Y",strtotime($row->order_date)); ?></td>
                                    <td><?php echo date("d/m/Y",strtotime($row->required_date)); ?></td>
                                    <td><?php echo $row->vendor_details->vendor_name; ?></td>
                                    <td class="text-right"><?php echo $row->stock_grand_total; ?></td>
                                </tr>
                                <?php } }else{?>
                                <td colspan="5" class="text-center">No Results found</td>
                                  <?php } ?>
                        </table>
                     </div>
                 </div>
                 </div>
        </section>
    </div>
</section>

<section class="box-group accordion-parent clearfix" id="accordion">
    <div class="panel clearfix no-panel">
      <div class="col-sm-12">
        <a class="cards-title" href="#mr-accordion" data-toggle="collapse" data-parent="#accordion">
          <i class="fa fa-line-chart" aria-hidden="true"></i>  MATERIAL RECEIPT
        </a>
      </div>
        <div class="clearfix"></div>
        <section id="mr-accordion" class="collapse clearfix">
            <div class="clearfix"><br></div>
            <div class="clearfix">
                <div class="col-xs-12">
                     <div class="table-responsive box-table">
                          <table class="table table-bordered table-theme personal-task ">
                                <tr>
                                    <th>MR No.</th>
                                    <th>Vendor</th>
                                    <th>MR Date</th>
                                    <th>Delivery Date</th>
                                </tr>
                             
                                <?php if(!empty($MRData)){?>
                                <?php foreach ($MRData as $row){?>
                                <tr>
                                    <td><?php echo $row->id;?></td>
                                    <td><?php echo $row->vendor_details->vendor_name; ?></td>
                                    <td><?php echo date("d/m/Y",strtotime($row->mrv_receipt_date)); ?></td>
                                    <td><?php echo date("d/m/Y",strtotime($row->dly_date)); ?></td>
                                </tr>
                                <?php } }else{?>
                                <td colspan="4" class="text-center">No Results found</td>
                                  <?php } ?>
                        </table>
                     </div>
                 </div>
                 </div>
        </section>
    </div>
</section>


<section class="box-group accordion-parent clearfix" id="accordion">
    <div class="panel clearfix no-panel">
      <div class="col-sm-12">
        <a class="cards-title" href="#inv-accordion" data-toggle="collapse" data-parent="#accordion">
          <i class="fa fa-line-chart" aria-hidden="true"></i>  INVOICE
        </a>
      </div>
        <div class="clearfix"></div>
        <section id="inv-accordion" class="collapse clearfix">
            <div class="clearfix"><br></div>
            <div class="clearfix">
                <div class="col-xs-12">
                     <div class="table-responsive box-table">
                          <table class="table table-bordered table-theme personal-task ">
                                <tr>
                                    <th>Invoice No.</th>
                                    <th>Order No.</th>
                                    <th>Vendor</th>
                                    <th>Inv. Date</th>
                                    <th>Amount</th>
                                </tr>
                             
                                <?php if(!empty($PIData)){?>
                                <?php foreach ($PIData as $row){?>
                                <?php 
                                        $class = '';
                                        if($row->invoice_number != ''){
                                            $inv_no = $row->invoice_number;
                                        }else{
                                            $class = 'bg-success';
                                            $inv_no = 'Direct Purchase'; 
                                        }
                                        if($row->po_id > 0){
                                            $order_no = $row->po_id;
                                        }else{
                                            $order_no = 'Direct Purchase'; 
                                        }
                                    ?>
                                <tr class="<?php echo $class; ?>">
                                     
                                    <td><?php echo $inv_no;?></td>
                                    <td><?php echo $order_no;?></td>
                                    <td><?php echo $row->vendor_details->vendor_name; ?></td>
                                    <td><?php echo date("d/m/Y",strtotime($row->invoice_date)); ?></td>
                                    <td class="text-right"><?php echo $row->grand_total; ?></td>
                                </tr>
                                <?php } }else{?>
                                <td colspan="5" class="text-center">No Results found</td>
                                  <?php } ?>
                        </table>
                     </div>
                 </div>
                 </div>
        </section>
    </div>
</section>

