<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("loadStudent", '
        $(document).ready(function() {

        var table_id ="#tbl_order_details";
        var table = $(table_id).DataTable({
             scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
            
            ajax: {
                url: "' . Yii::app()->createUrl('materialrequest/GetMaterialRequestList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            aaSorting : [[ 0, "desc" ]], 
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

  ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa"></i> Material Receipt Details
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('materialrequest/create','Add New Material','xl')"><i class="fa fa-plus"></i> ADD</button>
            </div>
        </header>
      
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_order_details">
                    <thead>
                        <tr>
                            <th>Sl.No</th>
                            <th>Receipt ID</th>
                            <th>File</th>
                            <th>Vendor Name</th>
                            <th>QC</th>
                            <th>Request Date</th>
                            <th>Status</th>
                            <th>Actions</th> 
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>Sl.No</th>
                            <th>Receipt ID</th>
                            <th>File</th>
                            <th>Vendor Name</th>
                            <th>QC</th>
                            <th>Request Date</th>
                            <th>Status</th>
                            <th>Actions</th>                         
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
