
<?php 
$cs = Yii::app()->getClientScript(); 
$cs->registerScript("loadTable",  "function loadTable(){
        
        var customer = parseInt($('#customer_id').val());
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        var location =  $('#location').val();
        var invoice_type =  $('#invoice_type').val();

        $('#loader').show();
        
        $.ajax({
            type: 'POST',
            url: '" . Yii::app()->createUrl('finance/getInvoicelist') . "',
            data: {'customer' : customer, 'from_date' : from_date, 'to_date' : to_date, 'location' : location, 'invoice_type' : invoice_type },
            success: function(data)
            {
                $('#details_div').html(data);
                $('#details_div').show();
                $('#loader').hide();
            }
        });

};", CClientScript::POS_HEAD);

?>

<?php    
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'receipt-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));

?>


    <ul class="clearfix form-ul material">
        <li class="col-sm-2">
            <?php echo CHtml::textField('from_date',date('01/m/Y'),  array('class' => 'datepicker','data-label'=>'From Date')); ?> 
        </li>
        <li class="col-sm-2">
            <?php echo CHtml::textField('to_date',date('t/m/Y'),  array('class' => 'datepicker','data-label'=>'To Date')); ?> 
        </li>
        <li class="col-sm-3">
            <?php echo CHtml::textField('customer_name','', array('data-label'=>'Customer')); ?>
            <?php echo CHtml::hiddenField('customer_id'); ?>
        </li>
        <li class="col-sm-3">
            <?php echo CHtml::dropdownlist('location','', MasLocation::getLocationNames(),array('class' => 'tooltipster','data-label'=>'Location')); ?> 
        </li>
        <li class="col-sm-2">
            <?php echo CHtml::dropdownlist('invoice_type','',  array('EN' => 'Entry', 'EX' => 'Exit'),array('class' => 'tooltipster','data-label'=>'Invoice Type')); ?> 
        </li>
    </ul>
    
    <div class='btn-wrap text-center'> 
        <button title="Load" onclick="loadTable();return false;" class='plan-save-btn btn btn-theme' target="_blank"><i class="fa fa-search"></i></button>
   </div>
   <br>
    <div id="details_div" style="display : none">
    </div>
    
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <?php

                     
                    echo CHtml::ajaxSubmitButton('Post & Print', Yii::app()->createUrl('finance/allocate&print=1'), array(
                        'dataType' => 'json',
                        'type' => 'post',
                        'success' => 'function(data) {
                            if(data.status=="success"){  
                                window.open("'. Yii::app()->createUrl('/finance/LedgerJournalPrint').'&id="+data.id,"_blank");
                                var receipt = data.form_no;
                                reloadTable("#tble_receipt_list");
                                reloadTable("#sales_table");
                                $("#loader").hide();
                                $(".x.close").click();
                                t8.success("Receipt details saved. Receipt No. R/"+receipt,"success");
                            }else{
                                $("#loader").hide();
                                $.each(data, function(key, val) {
                                    t8.error(""+val+"","error");
                                });                 
                            }
                        }',
                        'beforeSend' => 'function(){
                              $("#loader").show();
                        }',
                        ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
            ?>
    </div>
    <?php $this->endWidget(); ?>