
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadInventory", '
        $(document).ready(function() {
            var table_id ="#tbl_exit_details";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#from_date").val();
                data.to_date = $("#to_date").val();
                return data;
            }).DataTable({
                scrollY         : "380px",
                pageLength      : 50,
				
				columns: [
                {className: ""},
                {className: ""},
                {className: ""},
                {className: ""},               
                {className: "" },
                {className: "" },
                {className: "text-right"}, 
                {className: "text-right"},
                {className: ""},
                
            ],
				
				
                ajax: {
                    url: "' . Yii::app()->createUrl('exit/GetExitInvoiceList') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 1, "desc" ]],

            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

?>

	
	
	
    <section class="panel">
        <header class="panel-heading clearfix panel-theame" style="padding-right: 0px;">
		
            <i class="fa fa-money"></i> Exit Invoice
                    
					
					
					
				
            <div class="pull-right">
                <div class="col-md-3"></div>
                <div class="col-md-3">
                    <?php echo CHtml::textfield('from_date',date('d/m/Y'), array('class' => 'datepicker form-control','placeholder'=>'From Date')); ?>
                </div>
                <div class="col-md-3">
                    <?php    echo CHtml::textfield('to_date',date('d/m/Y'), array('class' => 'datepicker form-control','placeholder'=>'To Date'));     ?>
                </div>
                <div class="col-md-1">
					<button class="btn btn-sm btn-theme" title="Select Report" onclick="reloadTable('#tbl_exit_details')">
                        <i class="fa fa-search"></i>
                    </button> 
                </div>
                <div class="col-md-2" style="text-align: right;">
                 <?php  if (isset(Yii::app()->user->havePermissionOn['exitinvoice_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                
               <button class="btn btn-sm btn-theme" onclick="loadPopupModal('exit/ExitInvoice','NEW EXIT INVOICE','xl')"> <i class="fa fa-plus"></i> ADD</button>
                <?php  } ?> 
                </div>
            </div>
            
           
            
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_exit_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th width="10%">Inv.No.</th>
                            <th width="25%">Customer</th>                            
                            <th>Invoice Date</th>
                           <?php if(Yii::app()->user->mas_company_code=="ALMAS"){ ?>
                            <th width="10%">Time</th>
                            <th width="10%">Bill No</th>
                           <?php } 
                                else 
                                {
                                    ?>
                                     <th width="10%">Manifest No</th>
                                     <th width="10%">Shipment Reference</th>
                                    <?php
                                }
                            ?>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th width="10%">Inv.No.</th>
                            <th width="25%">Customer</th>                            
                           <th>Invoice Date</th>
                           <?php if(Yii::app()->user->mas_company_code=="ALMAS"){ ?>
                            <th width="10%">Time</th>
                            <th width="10%">Bill No</th>
                           <?php } 
                                else 
                                {
                                    ?>
                                     <th width="10%">Manifest No</th>
                                     <th width="10%">Shipment Reference</th>
                                    <?php
                                }
                            ?>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
