<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<div id ="div_service_item_details">
<div class="table-responsive">
    <table class="table table-hover table-bordered personal-task" id="order_item_table">        
        <tr>            
            <th>No</th>     
            <th>Product</th>            
            <th>Description</th>            
            <th>Qty</th>            
            <th>Unit</th>           
            <th>Rate</th>            
            <th>Amount</th>            
            <th class="bg-success">Additions</th>           
            <th class="bg-danger">Deductions</th>           
            <th>Net</th>            
            <th class="text-center">
                <a class="btn btn-sm btn-theme" href="javascript:void(0);" onclick="addTableRow($('#order_item_table'));"><i class="fa fa-plus"></i></a></th>  
        </tr>
       <?php
        foreach($modelOrderItems as $i => $modelOrderItems): ?>
        <tr>                
            <td><?php echo ($i+1); ?></td>

            <td><?php  echo $form->textField($modelOrderItems, "[" . $i . "]product_name", array('class'=>'tooltipster go', 'placeholder' => 'Type & Select',
                'onKeyup' => 'js:autoCompleteProduct(this.id,"order");','value'=>$modelOrderItems->product->part_number,
                'title' => 'Select product')); ?>                                        

                <?php echo $form->hiddenField($modelOrderItems, "[" . $i . "]product_id"); ?>                                    
                 <?php echo $form->error($modelOrderItems, "[" . $i . "]product_id"); ?>  
            </td>
            <td>
                <div id="div_description">                
                <?php echo $form->textArea($modelOrderItems, "[" . $i . "]description", array( 'class' => 'tooltipster desc go',  'title' => 'Add Description here'));  ?>                    
                <?php echo $form->error($modelOrderItems, "[" . $i . "]description"); ?>                
               </div>
            </td>                

            <td><?php echo $form->textField($modelOrderItems, "[" . $i . "]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#order_item_table"));')); ?>                    
                <?php echo $form->error($modelOrderItems, "[" . $i . "]quantity"); ?>  
            </td> 
            <td>
                <?php  echo $form->textField($modelOrderItems, "[" . $i . "]unit", array('class'=>'unit go','value'=>$modelOrderItems->orderunit->symbol)); ?>                    
                <?php echo $form->hiddenField($modelOrderItems,  "[" . $i . "]unit_id",array('value'=>$modelOrderItems->unit));?>
                <?php echo $form->error($modelOrderItems, "[" . $i . "]unit"); ?>                
            </td>                
            <td>
                  <?php echo $form->textField($modelOrderItems, "[" . $i . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#order_item_table"));')); ?>                    
                  <?php echo $form->error($modelOrderItems, "[" . $i . "]rate"); ?>                
            </td>                
            <td>
                    <?php echo $form->textField($modelOrderItems, "[" . $i . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true)); ?>                    
                    <?php echo $form->error($modelOrderItems, "[" . $i . "]amount"); ?>               
            </td>                
            <td class="bg-success nw">
                    <?php echo $form->textField($modelOrderItems, "[" . $i . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#order_item_table"));')); ?>                    
                    <?php echo $form->error($modelOrderItems, "[" . $i . "]addition_percentage"); ?>                    
                    <?php echo $form->textField($modelOrderItems, "[" . $i . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true)); ?>                   
                    <?php echo $form->error($modelOrderItems, "[" . $i . "]addition_amount"); ?>                             
            </td>                

        <td class="bg-danger nw">
           
                <?php echo $form->textField($modelOrderItems, "[" . $i . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#order_item_table"));')); ?>                    
                <?php echo $form->error($modelOrderItems, "[" . $i . "]deduction_percentage"); ?>                    

                <?php echo $form->textField($modelOrderItems, "[" . $i . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true)); ?>                    
                 <?php echo $form->error($modelOrderItems, "[" . $i . "]deduction_amount"); ?>                
          
        </td>                

        

            <td>
                
                <?php echo $form->textField($modelOrderItems, "[" . $i . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true)); ?>                    



                <?php echo $form->error($modelOrderItems, "[" . $i . "]net_amount"); ?>                    



                    <?php $total+=$modelOrderItems->net_amount; ?>                



           </td>                



            <td class="text-center nw" width="1%">                    

                        <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeTableRow($(\'#order_item_table\'),this)', 'title' => 'Remove this item')); ?>                

            </td>            



        </tr>        



            <?php endforeach; ?>    



    </table>

    <table class="table table-hover table-bordered table-nexted order_total">

            <tr class="bg-total">

                <td width="70%" class="text-right table_total_title">

                    <h2>Total</h2>

                </td>

                <td width="30%" class="text-right table_total">

                    <h2 class="total" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></h2>

                </td>

            </tr>

        </table>

       <?php $grand_total = $total; ?>   

    <table id="order_final_add_table" class="table table-hover table-bordered table-nexted">        

       <?php  foreach($modelOrderAdditions as $i => $modelOrderAdditions): ?>            

        <tr>               

             <td class="text-right td-in-6">

                 Additions                    

                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#order_final_add_table'));"><i class="fa fa-plus"></i></a>

                </td>   

                <td>

                    <?php echo $form->textField($modelOrderAdditions, "[" . $i . "]particular", array('class' => 'go particular', 'placeholder' => 'Particulars')); ?>                    

                </td>

                <td>

                        <?php echo $form->textField($modelOrderAdditions, "[" . $i . "]particular_value", array('onkeyup' => 'calculateValues($("#order_item_table"));', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => 'value')); ?>                    

                </td>

                <td>

                        <?php echo $form->textField($modelOrderAdditions, "[" . $i . "]calculated_value", array('readonly' => true, 'class' => 'value_rate additions_value go text-right')); ?>                    

                </td>

                <td width="0">                    

                    <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeExtrasRow($("#order_final_add_table"), this)')); ?>                    

                </td>                

                <?php $grand_total +=$modelOrderAdditions->calculated_value; ?>            

        </tr>       

 <?php endforeach; ?>   

    </table>    

    <table id="order_final_ded_table" class="table table-hover table-bordered  table-nexted">        



        <?php  foreach ($modelOrderDeductions as $i => $modelOrderDeductions): ?>           

        <tr>                
                    <td class="text-right td-in-6">

                            Deductions               

                <a class="btn btn-sm btn-theme " href="javascript:void(0);" onclick="addTableRow($('#order_final_ded_table'));"><i class="fa fa-plus"></i></a>             

                    </td>

                    <td>

                    <?php echo $form->textField($modelOrderDeductions, "[" . $i . "]particular", array('class' => 'go particular', 'placeholder' => 'Particulars')); ?>                    

                    </td>

                    <td>

                     <?php echo $form->textField($modelOrderDeductions, "[" . $i . "]particular_value", array('onkeyup' => 'calculateValues($("#order_item_table"));', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => 'value')); ?>                    

                    </td>

                    <td>

                     <?php echo $form->textField($modelOrderDeductions, "[" . $i . "]calculated_value", array('readonly' => true, 'class' => 'value_rate deductions_value go text-right')); ?>                                    

                    </td>    

                    <td width="0">

                    <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeExtrasRow($("#order_final_ded_table"), this)')); ?>                    

                    </td>      

                  <?php $grand_total -=$modelOrderDeductions->calculated_value; ?>            



        </tr>        



            <?php endforeach; ?>    



    </table>    



   <table class="table table-hover table-bordered table-nexted order_grand_total">

            <tr class="summary_tr bg-total">

                <td width="70%" class="text-right table_total_title">

                    <h1>Grand Total</h1></td>

                <td width="30%" class="text-right table_total">

                    <h1 class="grandtotal" class="text-right">

                <?php echo Yii::app()->numberFormatter->formatCurrency($grand_total, " "); ?>

                </h1></td>

            </tr>

        </table>

</div>
</div>
<?php

    $cs = Yii::app()->getClientScript();

$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id,frm)

		{

		var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "'+'&frm='+frm;

				$('#'+field_id).autocomplete({

                minLength   : 1,

                source      : function (request, response) { autoCompleteSource(request, response,url) },

                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},

                select          : function( event, ui ) {

                event.preventDefault();

                trigger_target_id  	=   $(event.target).attr('id');

				var product_id=ui.item.value; 	

                                var desc=ui.item.description; 

                                var unit_id=ui.item.unit_id;  

                                var unit_name=ui.item.unit_name;

                                var arr_fields= field_id.split('_');

                                var model_name   = arr_fields[0];

                                var row_field  = arr_fields[1];         

                                $('#OrderItem_'+row_field+'_description').val(desc);

                                $('#OrderItem_'+row_field+'_unit').val(unit_name); 

                                $('#OrderItem_'+row_field+'_unit_id').val(unit_id);  

                                $('#OrderItem_'+row_field+'_product_id').val(product_id);  

                            }

			})



		}", CClientScript::POS_HEAD);

$cs->registerScript("checkall" ,"function checkall()
        {
        $('#ckbCheckAll').click(function () {
            $('.checkBoxClass').prop('checked', $(this).prop('checked'));
        })
    }", CClientScript::POS_HEAD);
 ?>