<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteBank",  "function deleteBank(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=bank/deleteBank',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=bank/index';
                    t8.success('Bank Deleted SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadBank", '
        $(document).ready(function() {

        var table_id ="#tbl_bank_details";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('bank/GetBankList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-users"></i> Bank Details
            <div class="pull-right">
                <?php  if (isset(Yii::app()->user->havePermissionOn['bank_add']) ||  Yii::app()->user->authorised_user == 1) {?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('bank/create','Add New Bank','lg')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_bank_details">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Bank Name</th>
                            <th>Actions</th>
                            
                            
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th>Bank Name</th>
                            <th class="text-center">Actions</th>
                            
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
