<?php

/**
 * ContactForm class.
 * ContactForm is the data structure for keeping
 * contact form data. It is used by the 'contact' action of 'SiteController'.
 */
class UserProfile extends CFormModel {

    public $first_name;
    public $last_name;
    public $designation;
    public $email;
    public $phno;
    public $currentPassword;
    public $newPassword;
    public $newPassword_repeat;
    private $_user;
    public $signature;

    /**
     * Declares the validation rules.
     */
    public function rules() {
        return array(
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('email,phno,first_name,last_name', 'required', 'on' => 'saveprofile'),
            array('currentPassword', 'compareCurrentPassword', 'on' => 'password_updation'),
            array('currentPassword, newPassword, newPassword_repeat', 'required', 'on' => 'password_updation'),
            array('signature', 'safe'),
            array(
                'newPassword_repeat', 'compare',
                'compareAttribute' => 'newPassword',
                'message' => "New Passwords don't match", 'on' => 'password_updation'
            ),
        );
    }

    public function compareCurrentPassword($attribute, $params) {
        /* if (crypt($this->currentPassword, $this->currentPassword) != $this->_user->password) {
            $this->addError($attribute, 'Current Password is incorrect');
        } */
    	
    	//START Code modified on 08-04-2016 for secured password
    	$salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
    	$current_password = crypt($this->currentPassword, $salt);
    	//END Code modified on 08-04-2016 for secured password
    	 
    	if ($current_password != $this->_user->password) {
    		$this->addError($attribute, 'Current Password is incorrect');
    	}
    	//END Code modified on 08-04-2016 for secured password
    }

    public function init() {
        $this->_user = User::model()->findByPk(Yii::app()->user->id);
    }

    /**
     * Declares customized attribute labels.
     * If not declared here, an attribute would have a label that is
     * the same as its name with the first letter in upper case.
     */
    public function attributeLabels() {
        return array(
            'newPassword_repeat' => 'Confirm New Password',
        );
    }

}