<?php

/**
 * This is the model class for table "crm_tender_enquirey_list".
 *
 * The followings are the available columns in table 'crm_tender_enquirey_list':
 * @property integer $id
 * @property string $tender_no
 * @property string $title
 * @property string $description
 * @property integer $company
 * @property string $closing_date
 * @property string $location
 * @property string $created_date
 */
class TenderEnquireyList extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'crm_tender_enquirey_list';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('tender_no, title, description, company, closing_date, location, created_date', 'required'),
			array('company', 'numerical', 'integerOnly'=>true),
			array('tender_no, title, location', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, tender_no, title, description, company, closing_date, location, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tender_no' => 'Tender No',
			'title' => 'Title',
			'description' => 'Description',
			'company' => 'Company',
			'closing_date' => 'Closing Date',
			'location' => 'Location',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tender_no',$this->tender_no,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('company',$this->company);
		$criteria->compare('closing_date',$this->closing_date,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TenderEnquireyList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
