<?php

/**
 * This is the model class for table "{{temporary_table}}".
 *
 * The followings are the available columns in table '{{temporary_table}}':
 * @property integer $order_no
 * @property string $section_name
 * @property string $date
 * @property string $company_name
 * @property integer $qauantity
 * @property string $rate
 * @property string $value
 * @property integer $credit_debit_qty
 */
class TemporaryTable extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{temporary_table}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_no, section_name, date, company_name, qauantity, rate, value, credit_debit_qty', 'required'),
			array('order_no, qauantity, credit_debit_qty', 'numerical', 'integerOnly'=>true),
			array('section_name, company_name', 'length', 'max'=>255),
			array('rate, value', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,order_no, section_name, date, company_name, qauantity, rate, value, credit_debit_qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'order_no' => 'Order No',
			'section_name' => 'Section Name',
			'date' => 'Date',
			'company_name' => 'Company Name',
			'qauantity' => 'Qauantity',
			'rate' => 'Rate',
			'value' => 'Value',
			'credit_debit_qty' => 'Credit Debit Qty',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('order_no',$this->order_no);
		$criteria->compare('section_name',$this->section_name,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('company_name',$this->company_name,true);
		$criteria->compare('qauantity',$this->qauantity);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('value',$this->value,true);
		$criteria->compare('credit_debit_qty',$this->credit_debit_qty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TemporaryTable the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
