<?php
class StockOpeningBalance extends CActiveRecord {

    public function tableName() {
        return '{{stock_opening_balance}}';
    }

    public function rules() {

        return array(
            array('product_id,part_no,description,generic_name,brand_class,warehouse_id,rack_id,bin_id,created_by,created_date,qty', 'required'),
            array('part_no', 'length', 'max' => 100),
            array('description', 'length', 'max' => 250),
            array('generic_name', 'length', 'max' => 50),
            array('cost_rate', 'numerical'),
            array('product_id,brand_class,warehouse_id,rack_id,bin_id,created_by', 'numerical', 'integerOnly' => true),
            array('product_id,part_no,description,generic_name,brand_class,warehouse_id,rack_id,bin_id,created_by,created_date,qty', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'warehouse' => array(self::BELONGS_TO, 'MasInvWarehouse', 'warehouse_id'),
            'stock' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
            'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
            'brand' => array(self::BELONGS_TO, 'ProductClass', 'brand_class'),
        );
    }


    public function attributeLabels() {
    return array(
            'id' => 'ID',
            'product_id' => 'Product ID',
            'part_no' => 'Part No',
            'description' => 'Description',
            'generic_name' => 'Generic_name',
            'brand_class' =>  'brand/class',
            'warehouse_id' => 'warehouse ID',
            'rack_id' => 'rack ID',
            'bin_id' => 'bin ID',
            'created_by' => 'Created By',
            'created_date' => 'Created Date',
            'qty' => 'Quantity'
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $product = trim(Yii::app()->request->getParam('product'));
        $brand = trim(Yii::app()->request->getParam('brand'));
        
        if(!empty($brand)) {
        $criteria->addCondition('brand_class ='.$brand, 'AND');
        }
        if(!empty($product)) {
        $criteria->addCondition('part_no like "%'.$product.'%" OR description like "%'.$product.'%"', 'AND');
        }
        
        return new CActiveDataProvider($this, array(
            'pagination' => false,
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id ASC',
            ),
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}

