<?php
class StockLedger extends CActiveRecord {
    public $net_qty;
    public function tableName() {
        return '{{stock_ledger}}';
    }

    public function rules() {

        return array(
            array('transaction_date,product_id,part_no,description,generic_name,brand_class,warehouse_id,rack_id,bin_id,created_by,created_date,in_qty,out_qty,customer_vendor_id', 'required'),
            array('part_no', 'length', 'max' => 100),
            array('description', 'length', 'max' => 250),
            array('generic_name,type_description ', 'length', 'max' => 50),
            array('cost_rate,sales_price', 'numerical'),
            array('product_id,brand_class,warehouse_id,rack_id,bin_id,created_by,customer_vendor_id', 'numerical', 'integerOnly' => true),
            array('product_id,part_no,description,generic_name,brand_class,warehouse_id,rack_id,bin_id,created_by,created_date,qty', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            //'opening' => array(self::BELONGS_TO, 'StockOpeningBalance', '', 'foreignKey' => array('product_id'=>'product_id')),
            'warehouse' => array(self::BELONGS_TO, 'MasInvWarehouse', 'warehouse_id'),
            'stock' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'bin' => array(self::BELONGS_TO, 'MasInvBin', 'bin_id'),
            'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
            'brand' => array(self::BELONGS_TO, 'ProductClass', 'brand_class'),
            'company' => array(self::BELONGS_TO, 'Company', 'customer_vendor_id'),
            'directsales' => array(self::BELONGS_TO, 'DirectOrder', 'master_table_id'),
            'directpurchase' => array(self::BELONGS_TO, 'DirectPurchaseOrderGeneral', 'master_table_id'),
            'credit' => array(self::BELONGS_TO, 'Creditnote', 'master_table_id'),
            'debit' => array(self::BELONGS_TO, 'Purchasingdebitnote', 'master_table_id'),
            'delivery' => array(self::BELONGS_TO, 'DeliveryNote', 'master_table_id'),
        );
    }


    public function attributeLabels() {
    return array(
            'id' => 'ID',
            'product_id' => 'Product ID',
            'part_no' => 'Part No',
            'description' => 'Description',
            'generic_name' => 'Generic_name',
            'brand_class' =>  'brand/class',
            'warehouse_id' => 'warehouse ID',
            'rack_id' => 'rack ID',
            'bin_id' => 'bin ID',
            'created_by' => 'Created By',
            'created_date' => 'Created Date',
            'qty' => 'Quantity'
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $product = trim(Yii::app()->request->getParam('product'));
        $type = trim(Yii::app()->request->getParam('type'));
        $brand = trim(Yii::app()->request->getParam('brand'));
        $customer_vendor = trim(Yii::app()->request->getParam('customer_vendor'));
        $start_date = trim(Yii::app()->request->getParam('start_date'));
        $current_date = date('Y-m-d');
        if (!empty($start_date)) {
         $start_date=str_replace('/', '-', $start_date);
         $start_date=date("Y-m-d", strtotime($start_date));
        }
         $end_date = trim(Yii::app()->request->getParam('end_date'));
         if (!empty($end_date)) {
         $end_date=str_replace('/', '-', $end_date);
         $end_date =date("Y-m-d", strtotime($end_date));
         }
         
        if(!empty($brand)) {
        $criteria->addCondition('brand_class='.$brand, 'AND');
        }
        if(!empty($product)) {
        $criteria->addCondition('part_no like "%'.$product.'%" OR description like "%'.$product.'%"', 'AND');
        }
        if(!empty($customer_vendor)) {
        $criteria->addCondition('customer_vendor_id='.$customer_vendor, 'AND');
        }
        if (!empty($type)) {
        $criteria->addCondition('type="'.$type.'"', 'AND');
        }
        if (!empty($start_date)) {
        $criteria->addCondition('transaction_date>="'.$start_date.'"', 'AND');   
        }
        if (!empty($end_date)) {
        $criteria->addCondition('transaction_date<="'.$end_date.'"', 'AND');
        }
        
        return new CActiveDataProvider($this, array(
            'pagination' => false,
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id ASC',
            ),
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public static function getType(){
        
        $arr_type = array('D,DO'=>'Sales','QC,PR'=>'Purchase','GI'=>'Goods Issue','GR'=>'Goods Receipt','PGI'=>'Production Goods Issue','PGR'=>'Production Goods Receipt','CN'=>'Credit Note','DN'=>'Debit Note','MTM'=>'Material to Material Transfer','DT'=>'Direct Transfer','IDT'=>' Transfer Out','RI'=>'Transfer in','DM'=>'Damaged Item');
    
        return $arr_type;
    }
    public static function getTypeDes($type){
        
        $arr_type = array('D,DO'=>'Sales','QC,PR'=>'Purchase','D'=>'Sales','DO'=>'Sales','PR'=>'Purchase','QC'=>'Purchase','GI'=>'Goods Issue','GR'=>'Goods Receipt','PGI'=>'Production Goods Issue','PGR'=>'Production Goods Receipt','CN'=>'Credit Note','DN'=>'Debit Note','MTM'=>'Material to Material Transfer','DT'=>'Direct Transfer','IDT'=>' Transfer Out','RI'=>'Transfer in','DM'=>'Damaged Item');
        $type_desc = $arr_type[$type];
        return $type_desc;
    }
    
}

