<?php

/**
 * This is the model class for table "{{stock_history}}".
 *
 * The followings are the available columns in table '{{stock_history}}':
 * @property integer $id
 * @property string $msg
 * @property string $frm
 * @property integer $file_id
 * @property string $part_no
 * @property integer $product_id
 * @property integer $owner_id
 * @property integer $created_by
 * @property string $created_datetime
 */
class StockHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{stock_history}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id, msg, frm, file_id, part_no, product_id, owner_id,quantity,rate,old_rate,new_rate, created_by, created_datetime', 'required'),
			array('id, file_id, product_id, owner_id, created_by', 'numerical', 'integerOnly'=>true),
			array('frm, part_no', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, msg, frm, file_id, part_no, product_id, owner_id, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'msg' => 'Msg',
			'frm' => 'Frm',
			'file_id' => 'File',
			'part_no' => 'Part No',
			'product_id' => 'Product',
			'owner_id' => 'Owner',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('msg',$this->msg,true);
		$criteria->compare('frm',$this->frm,true);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('part_no',$this->part_no,true);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('owner_id',$this->owner_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return StockHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
