<?php

/**
 * This is the model class for table "{{salespricegroup_brandorclass_master}}".
 *
 * The followings are the available columns in table '{{salespricegroup_brandorclass_master}}':
 * @property integer $id
 * @property string $pricing_group
 * @property string $pricing_group_description
 * @property string $upload_place
 * @property string $default_pricing_group
 */
class SalesPriceGroupBrandorclassMaster extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{salespricegroup_brandorclass_master}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pricing_group, pricing_group_description, document', 'required'),
			array('pricing_group, upload_place', 'length', 'max'=>255),
			array('default_pricing_group', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, pricing_group, pricing_group_description, upload_place, default_pricing_group', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pricing_group' => 'Pricing Group',
			'pricing_group_description' => 'Pricing Group Description',
			'upload_place' => 'Upload Place',
			'document' => 'Document',
			'default_pricing_group' => 'Default Pricing Group',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pricing_group',$this->pricing_group,true);
		$criteria->compare('pricing_group_description',$this->pricing_group_description,true);
		$criteria->compare('upload_place',$this->upload_place,true);
		$criteria->compare('default_pricing_group',$this->default_pricing_group,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SalesPriceGroupBrandorclassMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
