<?php

/**
 * This is the model class for table "{{sales_price_group}}".
 *
 * The followings are the available columns in table '{{sales_price_group}}':
 * @property integer $id
 * @property integer $product_id
 * @property string $sales_price1
 * @property string $sales_price2
 * @property string $sales_price3
 * @property string $sales_price4
 * @property string $sales_price5
 * @property integer $uploaded_by
 * @property string $last_updated_date
 */
class SalesPriceGroup extends CActiveRecord
{
	public $product_name;
	public $product_description;
	
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sales_price_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('product_id, sales_price1, sales_price2, sales_price3, sales_price4, sales_price5, sales_price_group_file_name', 'required'),
				array('product_id', 'required'),
			array('product_id, uploaded_by', 'numerical', 'integerOnly'=>true),
			array('sales_price1', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, sales_price1, uploaded_by, last_updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'sales_price1' => 'Sales Price1',
			'uploaded_by' => 'Uploaded By',
			'sales_price_group_file_name' => 'File',
			'last_updated_date' => 'Last Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('sales_price1',$this->sales_price1,true);
		$criteria->compare('uploaded_by',$this->uploaded_by);
		$criteria->compare('last_updated_date',$this->last_updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SalesPriceGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
}
