<?php

/**
 * This is the model class for table "{{demo_item_details}}".
 *
 * The followings are the available columns in table '{{demo_item_details}}':
 * @property integer $id
 * @property integer $demo_monitoring_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property string $item_serial_no
 * @property integer $quantity
 * @property string $unit
 * @property integer $picked_qty
 * @property string $item_return_date
 */
class RmaSendVendorItemsReturn extends CActiveRecord
{
	
        public function tableName()
	{
		return '{{rma_send_vendor_items_return}}';
	}
	public function rules()
	{
		return array(
			array('return_qty,return_date', 'required'),
			array('send_vendor_item_id,return_qty', 'numerical', 'integerOnly'=>true),
                        array('serial_no', 'length', 'max'=>50),
			array('id,send_vendor_item_id,return_qty,return_date', 'safe', 'on'=>'search'),
		);
	}

	public function relations()
	{
	
		return array(
//                    'demo' => array(self::BELONGS_TO, 'DemoItemGeneral', 'demo_monitoring_id'),
//                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
//                    'unt' => array(self::BELONGS_TO, 'Unit', 'unit'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'send_vendor_item_id' => 'Demo Item Id',
			'return_qty' => 'Return Quantity',
			'return_date' => 'Item Return Date',
		);
	}

	public function search()
	{
		
		$criteria=new CDbCriteria;

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
