<?php

class RmaReceiptItems extends CActiveRecord {
    public $product_name;
    public $max_qty;
    public function tableName() {
        return '{{rma_receipt_items}}';
    }

    public function rules() {
        return array(
            array('product_id,qty', 'required'),
            array('rma_receipt_id,product_id,qty', 'numerical', 'integerOnly' => true),
            array('serial_no,description', 'length', 'max'=>255),
            array('rma_receipt_id,product_id,qty,serial_no', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
        'product' => array(self::BELONGS_TO, 'Store', 'product_id'),  
        );
    }
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'rma_receipt_id' => 'Receipt',
            'product_id' => 'Product',
            'serial_no' => 'Serial No',
            'qty' => 'Quantity',
        );
    }

    
    public function search() {
        $criteria = new CDbCriteria;
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
