<?php

/**
 * This is the model class for table "{{refund_request}}".
 *
 * The followings are the available columns in table '{{refund_request}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $invoice_no
 * @property string $bill_of_entry
 * @property string $date_requested
 * @property string $date_received
 * @property string $amount
 * @property string $notes
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_datetime
 */
class RefundRequest extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_name;
	public function tableName()
	{
		return '{{refund_request}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, invoice_no, bill_of_entry, date_requested', 'required'),
			array('customer_id, created_by', 'numerical', 'integerOnly'=>true),
			array('invoice_no, bill_of_entry', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, invoice_no, bill_of_entry, date_requested, date_received, amount, notes, isActive, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cus' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'invoice_no' => 'Invoice No',
			'bill_of_entry' => 'Bill Of Entry',
			'date_requested' => 'Date Requested',
			'date_received' => 'Date Received',
			'amount' => 'Amount',
			'notes' => 'Notes',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('bill_of_entry',$this->bill_of_entry,true);
		$criteria->compare('date_requested',$this->date_requested,true);
		$criteria->compare('date_received',$this->date_received,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RefundRequest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
