<?php

/**
 * This is the model class for table "{{rcpt_of_payment}}".
 *
 * The followings are the available columns in table '{{rcpt_of_payment}}':
 * @property string $id
 * @property string $company_id
 * @property string $notes
 * @property string $remarks
 * @property string $received_date
 * @property string $mode_of_payment
 * @property string $ref_number
 * @property string $isActive
 */
class RcptOfPayment extends CActiveRecord {

    public $company_name;
    public $searchstartdate;
    public $searchenddate;
    public $account_id;
    public $account_id1;
    public $amount;

     /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{rcpt_of_payment}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('company_id, mode_of_payment,received_date,realisation_date,ref_number,amount', 'required', 'on' => 'sales'),
             array('company_id, mode_of_payment, received_date,realisation_date,account_id,amount', 'required','on' => 'purchase'),
            array('company_id', 'length', 'max' => 20, 'on' => 'sales'),
            //array('own_company_id, own_branch_id', 'numerical', 'integerOnly' => true, 'on' => 'sales'),
            array('mode_of_payment,due,total', 'length', 'max' => 255, 'on' => 'sales'),
            array('ref_number,bank', 'length', 'max' => 255, 'on' => 'sales'),
            array('isActive', 'length', 'max' => 1, 'on' => 'sales'),
            array('notes, remarks', 'length', 'max' => 5000, 'on' => 'sales'),
             array('company_id', 'length', 'max' => 20, 'on' => 'purchase'),
            //array('own_company_id, own_branch_id', 'numerical', 'integerOnly' => true, 'on' => 'purchase'),
            array('mode_of_payment,due,total', 'length', 'max' => 255, 'on' => 'purchase'),
            array('ref_number', 'length', 'max' => 255, 'on' => 'purchase'),
            array('isActive', 'length', 'max' => 1, 'on' => 'purchase'),
            array('notes, remarks', 'length', 'max' => 5000, 'on' => 'purchase'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, company_id, notes, remarks, received_date,realisation_date,mode_of_payment, ref_number, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'recieved_invoice' => array(self::HAS_MANY, 'ReceivedInvoices', 'rcpt_id'),
            'recieved_amount' => array(self::STAT, 'ReceivedInvoices', 'rcpt_id', 'select' => 'SUM(received_amt)'),
            'paid_amount' => array(self::STAT, 'PaidInvoices', 'rcpt_id', 'select' => 'SUM(received_amt)'),
            'company' => array(self::BELONGS_TO, 'Customer', 'company_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'company_id' => 'Company',
            'notes' => 'Notes',
            'remarks' => 'Remarks',
            'received_date' => 'Received Date',
            'realisation_date'=>'realisation_date',
            'mode_of_payment' => 'Mode of Payment',
            'ref_number' => 'Ref Number',
            'due' => 'due',
            'bank'=>'bank',
            'total'=>'total',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('company_id', Yii::app()->session['company_id']);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('received_date', $this->received_date, true);
        $criteria->compare('mode_of_payment', $this->mode_of_payment, true);
        $criteria->compare('ref_number', $this->ref_number, true);
        $criteria->compare('isActive', $this->isActive, true);
        if (isset($_GET['month']))
            $criteria->condition = "YEAR(received_date)='" . date('Y') . "' AND MONTH(received_date) ='" . date('m', strtotime($_GET['month'])) . "'";
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        if (!empty($this->company_id))
            $condition[] = 'company_id="' . $this->company_id . '"';
        if (!empty($this->mode_of_payment))
            $condition[] = 'mode_of_payment="' . $this->mode_of_payment . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('received_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                 own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.company_id,t.received_date DESC',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return RcptOfPayment the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(rcvinv.received_amt) FROM `crm_rcpt_of_payment` JOIN `crm_received_invoices` as rcvinv where rcvinv.rcpt_id=crm_rcpt_of_payment.id AND crm_rcpt_of_payment.id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }

    public function getMode() {
        switch ($this->mode_of_payment) {
            case 'BT':
                return 'Bank Transfer';
                break;
            case 'C':
                return 'Cash Payment';
                break;
            case 'CH':
                return 'Cheque';
                break;
            default:
                return 'Cash Payment';
                break;
        }
    }

}
