<?php

/**
 * This is the model class for table "{{quotes_item_particular}}".
 *
 * The followings are the available columns in table '{{quotes_item_particular}}':
 * @property integer $id
 * @property integer $quotes_id
 * @property string $particular
 * @property double $percentage
 * @property double $value
 * @property integer $calculated_value
 * @property string $flag
 *
 * The followings are the available model relations:
 * @property Quotes $quotes
 */
class QuotesItemParticular extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{quotes_item_particular}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('quotes_id, particular, particular_value, calculated_value, flag', 'required'),
			array('quotes_id, calculated_value', 'numerical', 'integerOnly'=>true),
			array('percentage, value', 'numerical'),
			array('particular', 'length', 'max'=>255),
			array('flag', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, quotes_id, particular, percentage, value, calculated_value, flag', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'quotes' => array(self::BELONGS_TO, 'Quotes', 'quotes_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quotes_id' => 'Quotes',
			'particular' => 'Particular',
			'particular_value' => 'Value',
			'calculated_value' => 'Calculated Value',
			'flag' => 'Flag',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('quotes_id',$this->quotes_id);
		$criteria->compare('particular',$this->particular,true);
		$criteria->compare('particular_value',$this->particular_value);
		$criteria->compare('calculated_value',$this->calculated_value);
		$criteria->compare('flag',$this->flag,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return QuotesItemParticular the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
