<?php

/**
 * This is the model class for table "{{quotes_item}}".
 *
 * The followings are the available columns in table '{{quotes_item}}':
 * @property integer $id
 * @property integer $quotes_id
 * @property integer $product_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 *
 * The followings are the available model relations:
 * @property Quotes $quotes
 * @property Store $product
 */
class QuotesItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $unit;
    public $item_qty;

    public function tableName() {
        return '{{quotes_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('product_id, description, quantity, rate, amount, net_amount', 'required'),
            array('quotes_id, product_id', 'numerical', 'integerOnly' => true),
            array('quantity, rate, amount, addition_amount, deduction_amount, net_amount', 'numerical'),
            //array('description', 'length', 'max' => 255),
            array('quantity', 'length', 'max'=>10),
            array('addition_percentage, deduction_percentage', 'length', 'max' => 50),
            //array('product_id, rate', 'check_inventory'),
            array('rate', 'check_inventory'),
            /*array(
                'rate',
                'compare',
                'compareValue' => 0, 
                'operator' => '>',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),*/
            array(
                'net_amount',
                'compare',
                'compareValue' => 0, 
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than or equal to "{compareValue}".'
            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, quotes_id, product_id, description, quantity, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on' => 'search'),
        );
    }
    
    public function check_inventory($attribute,$params)
    {           
        if($this->product->inventory_type !=2 && $this->rate<=0){
            $this->addError('rate','Rate must be greater than 0');
        }               
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'quotes' => array(self::BELONGS_TO, 'Quotes', 'quotes_id'),
            'parent' => array(self::BELONGS_TO, 'Quotes', 'quotes_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unit' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'quoteunit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quotes_id' => 'Quotes',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'amount' => 'Amount',
            'addition_percentage' => 'Addition Percentage',
            'addition_amount' => 'Addition Amount',
            'deduction_percentage' => 'Deduction Percentage',
            'deduction_amount' => 'Deduction Amount',
            'net_amount' => 'Net Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('quotes_id', $this->quotes_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('rate', $this->rate);
        $criteria->compare('amount', $this->amount);
        $criteria->compare('addition_percentage', $this->addition_percentage);
        $criteria->compare('addition_amount', $this->addition_amount);
        $criteria->compare('deduction_percentage', $this->deduction_percentage);
        $criteria->compare('deduction_amount', $this->deduction_amount);
        $criteria->compare('net_amount', $this->net_amount);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return QuotesItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    
    public function  getUnit($procuct_id){
        $product = Store::model()->findByPk($procuct_id);
        $unit = Unit::model()->findByPk($product->unit_id);
        return $unit->symbol;
    }

}
