<?php

/**
 * This is the model class for table "{{purchasingcredit}}".
 *
 * The followings are the available columns in table '{{purchasingcredit}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $crm_user_id
 * @property integer $purchasing_invoice_id
 * @property string $vendor_id
 * @property integer $contact_id
 * @property double $exchange_rate
 * @property string $reference
 * @property string $currency_id
 * @property string $credited_amount
 * @property string $credit_date
 * @property string $reason
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $Iscreditnote_or_goodsreturn
 * @property string $isActive
 */
class Purchasingdebitnote extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $vendor_name;
    public $title;
    public $value;
    public $country;
    public $searchstartdate;
    public $searchenddate;
    public $project;
    public $invoice_name;
	public function tableName()
	{
		return '{{purchasing_debit_note}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('crm_user_id, purchasing_invoice_id,vendor_id,debited_date,reason,currency_id,exchange_rate', 'required'),
			array('file_id, crm_user_id, purchasing_invoice_id, contact_id', 'numerical', 'integerOnly'=>true),
			array('exchange_rate,file_id', 'numerical'),
			array('vendor_id', 'length', 'max'=>20),
			array('reference, currency_id', 'length', 'max'=>255),
			array('debited_amount', 'length', 'max'=>15),
			array('debited_amount', 'isGoodReturn'),
			array('Isdebitnote_or_goodsreturn, isActive', 'length', 'max'=>1),
			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, crm_user_id, purchasing_invoice_id, vendor_id, contact_id, exchange_rate, reference, currency_id, debited_amount, debited_date, reason, notes, terms_and_conditions, remarks, Isdebitnote_or_goodsreturn, isActive', 'safe', 'on'=>'search'),
		);
	}
	public function isGoodReturn()
	{
            if($this->Isdebitnote_or_goodsreturn == 'N' && $this->debited_amount=="") 
            {
                $this->addError($this->debited_amount,'Debit Amount cannot be blank.');
            }
	}
	/**
	 * @return array relational rules.
	 */
	public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'vendor' => array(self::BELONGS_TO, 'Company', 'vendor_id'),
            'vendor_details' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
            'items' => array(self::HAS_MANY, 'PurchasingdebitnoteItem', 'purchasingcredit_id'),
            'netAmount' => array(self::STAT, 'PurchasingdebitnoteItem', 'purchasing_debitnote_id', 'select' => 'SUM(net_amount)'),
            'netVat' => array(self::STAT, 'PurchasingdebitnoteItem', 'purchasing_debitnote_id', 'select' => 'SUM(tax_vat_amount)'),
            'purchaseinvoice' => array(self::BELONGS_TO, 'DirectPurchaseOrderGeneral', 'purchasing_order_id'),
            'adItems' => array(self::HAS_MANY, 'PurchasingDebitNoteAddition', 'purchasing_debit_note_id'),
            'dedItems' => array(self::HAS_MANY, 'PurchasingDebitNoteDeduction', 'purchasing_debit_note_id'),
            'invoice' => array(self::BELONGS_TO, 'DirectPurchaseOrderGeneral', 'purchasing_invoice_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'crm_user_id' => 'Crm User',
            'purchasing_invoice_id' => 'Purchasing Invoice',
            'vendor_id' => 'Vendor',
            'contact_id' => 'Contact',
            'exchange_rate' => 'Exchange Rate',
            'reference' => 'Reference',
            'currency_id' => 'currency_id',
            'debited_amount' => 'Debited Amount',
            'debited_date ' => 'Debit Date',
            'reason' => 'Reason',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'Isdebitnote_or_goodsreturn' => 'Isdebitnote Or Goodsreturn',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.
        /* $criteria = new CDbCriteria;
          $criteria->with = array('file', 'vendor');
          $criteria->together = true;
          $criteria->condition = "t.id like '%" . $_POST['search'] .  "%'
          OR file_id like '" . $_POST['search'] . "%'
          OR credit_date like '%" . $_POST['search'] . "%'
          OR vendor.company_name like '%" . $_POST['search'] . "%'
          OR file.current_process_status like '%" . $_POST['search'] . "%'
          ";
          return new CActiveDataProvider($this, array(
          'criteria' => $criteria,
          'sort' => array(
          'defaultOrder' => 't.id DESC, t.file_id DESC ,t.credit_date DESC',
          ),
          'pagination' => array('pageSize' => 5)
          )); */

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('purchasingcredit_search')) : $searchterm;
        $criteria->with = array('file', 'file.company');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //(int) Yii::app()->session['company_id'] > 0 ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
            							t.purchasing_invoice_id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.debited_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function generatereport() {
        $criteria = new CDbCriteria;
        $criteria->condition = "isActive   =   'Y'";
        if (isset($_POST['rp_from_date']) && isset($_POST['rp_to_date'])) {
            $criteria->condition .= ' AND debited_date BETWEEN "' . $_POST['rp_from_date'] . '" AND "' . $_POST['rp_to_date'] . '"';
            if (isset($_POST['vendor_id']))
                $criteria->condition .= ' AND vendor_id in ( ' . $_POST['vendor_id'] . ')';
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.debited_date DESC,t.id DESC, t.file_id DESC',
            ),
            'pagination' => array('pageSize' => 500)
        ));
    }


    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'vendor', 'purchaseinvoice', 'purchaseinvoice.purchaseorder');
        if (!empty($this->vendor_id))
            $condition[] = 't.vendor_id="' . $this->vendor_id . '"';
        if (!empty($this->project))
            $condition[] = 'purchaseorder.project="' . $this->project . '"';
        if (!empty($this->country))
            $condition[] = 'vendor.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 'debited_amount<="' . $this->value . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('debited_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.debited_date DESC,t.id DESC,t.file_id DESC,t.vendor_id',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Purchasingcredits the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(debited_amount) FROM `crm_purchasing_debit_note` where id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }

}
