<?php

/**
 * This is the model class for table "{{purchasing_requisition_item}}".
 *
 * The followings are the available columns in table '{{purchasing_requisition_item}}':
 * @property integer $id
 * @property integer $requisition_id
 * @property integer $product_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 */
class PurchasingRequisitionItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $unit_id;
    public function tableName() {
        return '{{purchasing_requisition_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_name, description, quantity ', 'required'),
            array('purchasing_requisition_id, product_id', 'numerical', 'integerOnly' => true),
            array('quantity', 'numerical'),
            array('description, unit', 'length', 'max' => 255),
            array('quantity', 'length', 'max'=>10),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, purchasing_requisition_id, product_id, description, quantity, unit', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'purchasingrequisition' => array(self::BELONGS_TO, 'PurchasingRequisition', 'purchasing_requisition_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'requisitionunit' => array(self::BELONGS_TO, 'Unit', 'unit'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'purchasing_requisition_id' => 'Requisition',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit' => 'Unit',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('purchasing_requisition_id', $this->purchasing_requisition_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('unit', $this->unit);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 5) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingRequisitionItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
