<?php

/**
 * This is the model class for table "{{purchasing_requisitions}}".
 *
 * The followings are the available columns in table '{{purchasing_requisitions}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $crm_user_id
 * @property string $title
 * @property string $note
 * @property string $requisition_date
 * @property string $required_date
 * @property integer $tel_ph
 * status
 * vendor_id
 * @property string $isActive
 */
class PurchasingRequisition extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
public $requisitionunit;
    public function tableName() {
        return '{{purchasing_requisition}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('requisition_date,required_date,isActive,file_title','required'),
            array('file_id, crm_user_id, tel_ph,customer_id', 'numerical', 'integerOnly' => true),
            array('file_title,vendor_id', 'length', 'max' => 255),
            array('isActive,status', 'length', 'max' => 1),
            array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
            //array('required_date', 'type', 'type'=>'datetime', 'datetimeFormat'=>'yyyy-MM-dd hh:mm'), 
            // array('required_date', 'CDateValidator'),
            array(
                'required_date',
                'compare',
                'compareAttribute' => 'requisition_date',
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id,vendor_id,crm_user_id,file_title,requisition_date, required_date, tel_ph, isActive,status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'employee' => array(self::BELONGS_TO, 'User', 'crm_user_id,customer_id'),
            'items' => array(self::HAS_MANY, 'PurchasingRequisitionItem', 'purchasing_requisition_id'),
            'stockitems' => array(self::HAS_MANY, 'PurchasingRequisitionStockItem', 'purchasing_requisition_id', 'order' => 'stockitems.id asc'),
            'nonstockitems' => array(self::HAS_MANY, 'PurchasingRequisitionNonStockItem', 'purchasing_requisition_id', 'order' => 'nonstockitems.id asc'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'customer_id' => 'Employee',
            'crm_user_id' => 'Crm User',
            'file_title' => 'Title',
            'requisition_date' => 'Requisition Date',
            'required_date' => 'Required Date',
            'tel_ph' => 'Tel Ph',
            'isActive' => 'Is Active',
            'vendor_id' => 'Vendor ID',
            'status' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('req_search')) : $searchterm;
        $criteria->with = array('file', 'file.company');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        } else {
            $criteria->addCondition('file.current_process_status="P_R"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.requisition_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public static function getRequisition() {
        $condition = 'status =  "P"';
        $model = PurchasingRequisition::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'file_id');
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingRequisitions the static model class
     */
    public function getProduct() {
        $product = null;
        foreach ($this->items as $item)
            $product.=$item->description;
        return $product;
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
