<?php

/**
 * This is the model class for table "{{purchase_order_item}}".
 *
 * The followings are the available columns in table '{{purchase_order_item}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $product_id
 * @property string $description
 * @property double $quantity
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 */
class PurchasingOrderItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $unit;
    public $tot_quantity_by_class;
    public $tot_value_by_class;

    public function tableName() {
        return '{{purchasing_order_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_name, quantity', 'required'),
            array('purchasing_order_id, product_id', 'numerical', 'integerOnly' => true),
            array('quantity,rate, amount', 'numerical'),
            //  array('rate', 'numerical', 'min'=>1),
            array('description', 'length', 'max' => 255),
            array('quantity', 'length', 'max'=>10),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, purchasing_order_id, product_id, description, quantity, rate, amount', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'purchaseorder' => array(self::BELONGS_TO, 'PurchasingOrder', 'purchasing_order_id'),
            'parent' => array(self::BELONGS_TO, 'PurchasingOrder', 'purchasing_order_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'purchasing_order_id' => 'Purchasing Order',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'rate' => 'Rate',
            'amount' => 'Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search() {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria = new CDbCriteria;

      $criteria->compare('id', $this->id);
      $criteria->compare('purchasing_order_id', $this->purchasing_order_id);
      $criteria->compare('product_id', $this->product_id);
      $criteria->compare('description', $this->description, true);
      $criteria->compare('quantity', $this->quantity);
      $criteria->compare('rate', $this->rate);
      $criteria->compare('amount', $this->amount);

      if (isset($_GET['product_id']))
      $criteria->condition = "product_id=" . (int) $_GET['product_id'][0];

      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.id DESC',
      ),
      'pagination' => array('pageSize' => 10)
      ));
      } */
    public function search() {
        $criteria = new CDbCriteria;
        $criteria->with = "parent.file";
        if (isset($_GET['product_id']))
            $criteria->condition = "product_id=" . (int) $_GET['product_id'][0];
        if (isset($_GET['order_id']))
            $criteria->condition = "purchasing_order_id=" . (int) $_GET['order_id'][0];
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    public function openPoItems() {
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $criteria = new CDbCriteria;
        $criteria->with = array("parent.file", "parent.file.materialReceipt");
        $criteria->together = true;
        $criteria->addCondition("product_id=" . $product_id . " AND (file.current_process_status='P_O' OR file.current_process_status='P_MR' OR file.current_process_status='M_R')", "AND");
        //$criteria->addCondition("materialReceipt.qcchecked='Y'", 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    public function generatepurchasehistory() {
        $criteria = new CDbCriteria;
        if (isset($_POST['product_id']))// if isadmin
            $criteria->condition = "product_id=" . (int) $_POST['product_id'];
        $criteria->with = 'purchaseorder';
        if (isset($_POST['purchase_hist_start_date']) && isset($_POST['purchase_hist_end_date']) && isset($_POST['purchase_history_product_id']))
            $criteria->condition .= 'product_id   = "' . $_POST['purchase_history_product_id'] . '" AND purchaseorder.order_date BETWEEN "' . $_POST['purchase_hist_start_date'] . '" AND "' . $_POST['purchase_hist_end_date'] . '"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'purchaseorder.order_date DESC',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchaseOrderItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function qccheckdate($data, $row) {
        //$file_id = PurchasingOrder::model()->findbypk($data->purchasing_order_id)->file_id;
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT MAX(qc_check_date) FROM 
            {{purchasing_material_receipt}} 
            where po_id=" . $data->purchasing_order_id);
        if ($command->queryScalar() > 0 && $this->quantityreceived($data, $row) > 0)
            return ($command->queryScalar());
        else
            return '-';
    }

    public function quantityreceived($data, $row) {
        $model = PurchasingMaterialreceipt::model()->findAll(array('condition' => 'po_id=' . $data->purchasing_order_id));
        $qnty = 0;
        foreach ($model as $test) {
            $test1 = PurchasingMaterialreceiptItem::model()->findAll(array('condition' => 'purchasing_materialreceipt_id=' . $test->id . " and product_id=" . $data->product_id));

            foreach ($test1 as $test2) {
                $qnty = $qnty + $test2->qcchecked_quantity;
            }
        }
        $qnty = $qnty . ".00";
        return $qnty;
    }

    public function purchaseHistory($searchterm = null) {
        $criteria = new CDbCriteria;
        $criteria->with = array('product');
        //$criteria->together = FALSE;


        /*$criteria->addCondition('product.company_id =' . Yii::app()->user->master_user_company_id .
                ' AND  product.company_branch_id =' . Yii::app()->user->master_user_branch_id, 'AND');*/

        $criteria->addCondition('t.quantity>0', 'AND');
        $criteria->group = 'product.part_number';
        $searchterm = trim(Yii::app()->request->getParam('search'));
        if (!empty($searchterm)) {
            $criteria->addCondition('   product.part_number like "%' . $searchterm . '%" OR 
                                        product.generic_name like "%' . $searchterm . '%" OR 
                                        product.description like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'product.part_number,product.generic_name/*,productclass.product_class*/',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false
        ));
    }

    public function getTotalOrderedQuantity() {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{purchasing_order_item}} 
            where product_id=" . $this->product_id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function getTotalQCchechedQuantity() {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(qcchecked_quantity) FROM 
            {{purchasing_material_receipt_item}} 
            where product_id=" . $this->product_id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

}
