<?php

/**
 * This is the model class for table "{{purchasing_material_receipts}}".
 *
 * The followings are the available columns in table '{{purchasing_material_receipts}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $po_id
 * @property integer $vendor_id
 * @property string $dly_no
 * @property string $dly_date
 * @property string $shipped_by
 * @property string $awb_no
 * @property string $tracking_no
 * @property string $others
 * @property string $storekeeper_notes
 * @property string $qc_check_notes
 * @property string $qc_check_date
 * @property integer $lot_no
 * @property string $mrv_receipt_date
 */
class PurchasingMaterialreceipt extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $vendor_name;
    public $qc_checked_employee_name;
    public $title;
    public $qc_all;
    public $qc;
    public $country;
    public $searchstartdate;
    public $searchenddate;
    public $project;
    public $project_name;

    public function tableName() {
        return '{{purchasing_material_receipt}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id,po_id, vendor_id, dly_no, dly_date, mrv_receipt_date,awb_no,project_id', 'required'),
            array('qc_check_date', 'required', 'on' => 'qualitycheck'),
            array('crm_user_id,file_id, po_id, vendor_id, lot_no', 'numerical', 'integerOnly' => true),
            array('dly_no, shipped_by, awb_no, tracking_no, others, storekeeper_notes,qc_checked_employee_name,qc_check_notes, qc_check_date', 'length', 'max' => 255),
            array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('crm_user_id,id, file_id, po_id, qc_checked_employee, vendor_id, dly_no, dly_date, shipped_by, awb_no, tracking_no, others, storekeeper_notes, qc_check_notes,stock_updated, qc_check_date, lot_no, mrv_receipt_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'vendor' => array(self::BELONGS_TO, 'Company', 'vendor_id'),
            'vendor_details' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
            'project_details' => array(self::BELONGS_TO, 'MasProject', 'project_id'),
            'purchaseorder' => array(self::BELONGS_TO, 'PurchasingOrder', 'po_id'),
            'items' => array(self::HAS_MANY, 'PurchasingMaterialreceiptItem', 'purchasing_materialreceipt_id'),
            'projectname' => array(self::BELONGS_TO, 'MasProject', 'project'),
            'sippedby' => array(self::BELONGS_TO, 'MasShipping', 'shipped_by'),
            'employee' => array(self::BELONGS_TO, 'User', 'qc_checked_employee'),
                //'qccheckeduser'=> array(self::BELONGS_TO, 'MasUser', 'qc_checked_employee'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'po_id' => 'PO',
            'vendor_id' => 'Vendor',
            'dly_no' => 'Delivery No',
            'dly_date' => 'Delivery Date',
            'shipped_by' => 'Shipping By',
            'awb_no' => 'AWB No',
            'tracking_no' => 'Tracking No',
            'others' => 'Others',
            'storekeeper_notes' => 'Storekeeper Notes',
            'qc_check_notes' => 'QC Notes',
            'qc_check_date' => 'QC Date',
            'lot_no' => 'Lot No',
            'mrv_receipt_date' => 'MRV Receipt Date',
            'qc_checked_employee' => 'QC By <span class="required">*</span>',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function materialreceiptforinvoicesearch() {
        $criteria->with = array('file');
        $criteria->condition = 'file.current_process_status in("M_R","P_MR") AND qcchecked ="Y"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.mrv_receipt_date DESC,t.id DESC, t.file_id DESC ',
            ),
            'pagination' => array('pageSize' => 15)
        ));
    }

    public function qualitychecksearch($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('qccheck_mr_search')) : $searchterm;
        $criteria->with = array('file', 'file.company');
       /* $criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //(int) Yii::app()->session['company_id'] > 0 ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        t.po_id like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        } else {
            $criteria->addCondition('   qcchecked ="N" AND file.current_process_status="P_MR"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.mrv_receipt_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function materialreceiptsearch() {
        $criteria->with = array('file');
        $criteria->condition = 'file.current_process_status ="P_MR"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.mrv_receipt_date DESC',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('purchase_mr_search')) : $searchterm;
        $qccheck = empty($qccheck) ? trim(Yii::app()->request->getParam('qccheck')) : $qccheck;
        $criteria->with = array('file', 'file.company');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //(int) Yii::app()->session['company_id'] > 0 ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.po_id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        else
            $criteria->addCondition('    file.current_process_status="P_MR"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.mrv_receipt_date DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function generatereport() {
        $criteria = new CDbCriteria;
        if (isset($_POST['rp_from_date']) && isset($_POST['rp_to_date'])) {
            $criteria->condition = 'mrv_receipt_date BETWEEN "' . $_POST['rp_from_date'] . '" AND "' . $_POST['rp_to_date'] . '"';
            if (isset($_POST['vendor_id']))
                $criteria->condition .= ' AND vendor_id in ( ' . $_POST['vendor_id'] . ')';
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.mrv_receipt_date DESC',
            ),
            'pagination' => array('pageSize' => 500)
        ));
    }

    public function forPurchasingInvoiceSearch() {
        $criteria = new CDbCriteria;
        if (isset($_POST['file_id'])) {
            $criteria->condition = 'file_id=' . $_POST['file_id'];
            $criteria->condition.=' AND qcchecked="Y" AND invoiced<>"Y"';
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.file_id ,t.dly_date DESC',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /* public function report($searchterm=null) {
      $criteria = new CDbCriteria;
      if ($searchterm != null) {
      $criteria->with = array('file', 'vendor');
      $criteria->condition = "t.id like '%" . $searchterm.  "%'
      OR file_id like '%" . $searchterm . "%'
      OR mrv_receipt_date like '%" . $searchterm . "%'
      OR vendor.company_name like '%" . $searchterm . "%'
      OR file.current_process_status like '%" . $searchterm . "%'
      ";
      }
      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.id DESC, t.file_id DESC ,t.mrv_receipt_date DESC',
      ),
      'pagination' => array('pageSize' => 5)
      ));
      } */

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'vendor', 'purchaseorder');
        if (!empty($this->vendor_id))
            $condition[] = 't.vendor_id="' . $this->vendor_id . '"';
        if (!empty($this->project))
            $condition[] = 'purchaseorder.project="' . $this->project . '"';
        if (!empty($this->country))
            $condition[] = 'vendor.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 'grand_total<="' . $this->value . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('mrv_receipt_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.vendor_id,t.mrv_receipt_date DESC',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingMaterialReceipts the static model class
     */
    public static function check($x) {
        return false;
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
