<?php

/**
 * This is the model class for table "{{purchasing_invoice_item_details}}".
 *
 * The followings are the available columns in table '{{purchasing_invoice_item_details}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $invoice_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 * @property double $addition_percentage
 * @property double $addition_amount
 * @property double $deduction_percentage
 * @property double $deduction_amount
 * @property double $net_amount
 */
class PurchasingInvoiceItemDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{purchasing_invoice_item_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, invoice_id, description, quantity, unit, rate, amount, net_amount', 'required'),
			array('id, product_id, invoice_id, unit', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'numerical'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, invoice_id, description, quantity, unit, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'invoice_id' => 'Invoice',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'rate' => 'Rate',
			'amount' => 'Amount',
			'addition_percentage' => 'Addition Percentage',
			'addition_amount' => 'Addition Amount',
			'deduction_percentage' => 'Deduction Percentage',
			'deduction_amount' => 'Deduction Amount',
			'net_amount' => 'Net Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('invoice_id',$this->invoice_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('unit',$this->unit);
		$criteria->compare('rate',$this->rate);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('addition_percentage',$this->addition_percentage);
		$criteria->compare('addition_amount',$this->addition_amount);
		$criteria->compare('deduction_percentage',$this->deduction_percentage);
		$criteria->compare('deduction_amount',$this->deduction_amount);
		$criteria->compare('net_amount',$this->net_amount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchasingInvoiceItemDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
