<?php

/**
 * This is the model class for table "{{production_order_item}}".
 *
 * The followings are the available columns in table '{{production_order_item}}':
 * @property integer $id
 * @property integer $production_order_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $description
 * @property string $unit
 * @property double $quantity
 * @property double $rate
 * @property double $amount
 */
class ProductionOrderItem extends CActiveRecord
{
	public $unit_name;
        /**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{production_order_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, product_name, description, unit, quantity, rate, amount', 'required'),
                     array('quantity', 'numerical', 'min'=>1),
			array('production_order_id, product_id,quantity', 'numerical', 'integerOnly'=>true),
			array('rate, amount', 'numerical'),
			array('product_name, description, unit', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, production_order_id, product_id, product_name, description, unit, quantity, rate, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit'),
                );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'production_order_id' => 'Production Order',
			'product_id' => 'Product',
			'product_name' => 'Product Name',
			'description' => 'Description',
			'unit' => 'Unit',
			'quantity' => 'Quantity',
			'rate' => 'Rate',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('production_order_id',$this->production_order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('rate',$this->rate);
		$criteria->compare('amount',$this->amount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProductionOrderItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
