<?php

/**
 * This is the model class for table "{{received_invoices}}".
 *
 * The followings are the available columns in table '{{received_invoices}}':
 * @property string $rcpt_id
 * @property string $invoice_id
 * @property double $invoice_amt
 * @property double $received_amt
 */
class PaidInvoices extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $searchstartdate;
    public $searchenddate;
    public $company_id;
    public $mode_of_payment;
    public $received_date;
    public $realisation_date_from;
    public $realisation_date_to;

    public function tableName() {
        return '{{paid_invoices}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('invoice_id, received_amt', 'required'),        	array('received_amt', 'required'),            array('received_amt', 'numerical'),            array('rcpt_id, invoice_id', 'length', 'max' => 20),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('rcpt_id, invoice_id, received_amt', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'recpt' => array(self::BELONGS_TO, 'RcptOfPayment', 'rcpt_id'),
            'invoice' => array(self::BELONGS_TO, 'PurchasingInvoice', 'invoice_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'rcpt_id' => 'Rcpt',
            'invoice_id' => 'Invoice',
            'received_amt' => 'Paid Amt',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('rcpt_id', $this->rcpt_id, true);
        $criteria->compare('invoice_id', $this->invoice_id, true);
        $criteria->compare('received_amt', $this->received_amt);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('recpt');
        if (!empty($this->company_id))
            $condition[] = 'recpt.company_id="' . $this->company_id . '"';
        if (!empty($this->mode_of_payment))
            $condition[] = 'recpt.mode_of_payment="' . $this->mode_of_payment . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('recpt.received_date', $this->searchstartdate, $this->searchenddate);
        }
        if (!empty($this->mode_of_payment))
            if ($this->mode_of_payment == 'CH')
                if (!empty($this->realisation_date_from) && !empty($this->realisation_date_to))
                    $criteria->addBetweenCondition('recpt.realisation_date', $this->realisation_date_from, $this->realisation_date_to);
       /* $criteria->addCondition('recpt.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                 recpt.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'recpt.received_date DESC,t.id DESC,recpt.company_id',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ReceivedInvoices the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            //$command = $connection->createCommand("SELECT SUM(received_amt) FROM `crm_paid_invoices` where id in ($ids)");
            $command = $connection->createCommand("SELECT SUM(received_amt*inv.exchange_rate) FROM `crm_paid_invoices` AS r_inv JOIN `crm_purchasinginvoice` AS inv ON inv.id=r_inv.invoice_id where r_inv.id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }

}
