<?php

/**
 * This is the model class for table "{{mas_quotation_close_reason}}".
 *
 * The followings are the available columns in table '{{mas_quotation_close_reason}}':
 * @property integer $id
 * @property string $reason
 * @property integer $company_id
 * @property integer $company_branch_iud
 * @property string $isActive
 */
class MasTermsAndConditions extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_terms_and_conditions}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('term_name,terms', 'required'),
            array('id', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,terms,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'term_name' => 'Term',
            'terms' => 'Terms & Conditions',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search() {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria = new CDbCriteria;

      $criteria->compare('id', $this->id);
      $criteria->compare('reason', $this->reason, true);
      $criteria->compare('company_id', $this->company_id);
      $criteria->compare('company_branch_id', $this->company_branch_iud);
      $criteria->compare('isActive', $this->isActive, true);

      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      ));
      } */
    public function search() {
        $criteria = new CDbCriteria;
        //$searchterm = trim(Yii::app()->request->getParam('unit_name'));
        $criteria->addCondition('isActive =  "Y"');
        //if (!empty($searchterm))
        //$criteria->addCondition('unit_name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasQuotationCloseReason the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public static function getTerms() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'term_name ASC'));
        return CHtml::listData($model, 'id', 'term_name');
     }
    
   

}
