<?php

/**
 * This is the model class for table "crm_mas_project".
 *
 * The followings are the available columns in table 'crm_mas_project':
 * @property integer $id
 * @property string $project_no
 * @property string $project_title
 * @property integer $customer_id
 * @property string $description
 * @property string $amount
 * @property integer $currency
 * @property integer $amount_bc
 * @property string $contact_person
 * @property integer $type
 * @property string $location
 * @property string $start_date
 * @property string $end_date
 * @property string $isActive
 * @property integer $project_head
 * @property string $project_head_mail
 * @property string $isComplete
 */
class MasProject extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public  $currency_name;
        public $customer_name;
        public function tableName()
	{
		return '{{mas_project}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('project_no, customer_id, description, type, location, start_date, end_date, project_head, project_head_mail', 'required'),
			array('customer_id, currency, amount_bc, project_head', 'numerical', 'integerOnly'=>true),
			array('project_no, project_title, contact_person,type, location, project_head_mail', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>11),
			array('isActive, isComplete', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_no, project_title, customer_id, description, amount, currency, amount_bc, contact_person, type, location, start_date, end_date, isActive, project_head, project_head_mail, isComplete', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                        'company' => array(self::BELONGS_TO, 'Company', 'customer_id'),
                        'mascurrency' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
                        'user' => array(self::BELONGS_TO, 'User', 'project_head'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_no' => 'Project No',
			'project_title' => 'Project Title',
			'customer_id' => 'Customer',
			'description' => 'Description',
			'amount' => 'Amount',
			'currency' => 'Currency',
			'amount_bc' => 'Amount/Bc',
			'contact_person' => 'Contact Person',
			'type' => 'Type',
			'location' => 'Location',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'isActive' => 'Is Active',
			'project_head' => 'Project Head',
			'project_head_mail' => 'Project Head Mail',
			'isComplete' => 'Is Complete', 
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_no',$this->project_no,true);
		$criteria->compare('project_title',$this->project_title,true);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('currency',$this->currency);
		$criteria->compare('amount_bc',$this->amount_bc);
		$criteria->compare('contact_person',$this->contact_person,true);
		$criteria->compare('type',$this->type);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('project_head',$this->project_head);
		$criteria->compare('project_head_mail',$this->project_head_mail,true);
		$criteria->compare('isComplete',$this->isComplete,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasProject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getProject() {
            //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id.' AND company_branch_id='.Yii::app()->user->master_user_branch_id;
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition));
            return CHtml::listData($model, 'id', 'project_title');
        }
}
