<?php
class MasLocation extends CActiveRecord {

    /**

     * @return string the associated database table name

     */

    public function tableName() {

        return '{{mas_location}}';

    }

    /**

     * @return array validation rules for model attributes.

     */

    public function rules() {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('location', 'required'),
            array('location', 'unique'),
//          array('product_class, description', 'length', 'max' => 255),

            array('id, location,isActive', 'safe', 'on' => 'search'),

        );

    }

    /**

     * @return array relational rules.

     */
    public function relations() {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(
        );
    }

    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels() {

        return array(

            'id' => 'ID',
            'location' => 'Location',
            'isActive' => 'isActive',

        );

    }
public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('location',$this->location);
                $criteria->compare('isActive',$this->isActive);		
                             
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return Store the static model class

     */

    public static function model($className = __CLASS__) {

        return parent::model($className);

    }

    public static function getLocationNames() {

        $model = self::model()->findAll(array('select' => array('id', 'location'), 'order' => 'location'));

        return CHtml::listData($model, 'id', 'location');

    }

}

