<?php

/**
 * This is the model class for table "{{mas_inv_warehouse}}".
 *
 * The followings are the available columns in table '{{mas_inv_warehouse}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property InventoryItems[] $inventoryItems
 */
class MasInvWarehouse extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_inv_warehouse}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'required'),
            array('name', 'length', 'max' => 255),
            array('isActive,isBaseWareHouse', 'length', 'max' => 1),
            array('name', 'unique', 'on' => 'add'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'inventoryItems' => array(self::HAS_MANY, 'InventoryItems', 'default_warehouse'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('warehouse_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasInvWarehouse the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getWarehouses() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
    	$model = self::model()->findAll(array('condition' => $condition,'order'=>'isBaseWareHouse ASC'));
        return CHtml::listData($model, 'id', 'warehouse_name');
    }
   
 	public static function getWarehousesforeachproduct($id) {
        $modelProductLocation = ProductLocation::model()->findAll(array('condition'=>'stock_id='.$id.' and warehouse_id!=""'));
        //if production location is not availble, then execute this section
        //Add a new production location for default warehouse
		//echo "count=".count($modelProductLocation)."<br>";
        if(count($modelProductLocation)==0)
        {
        	$arr_default_warehouse = MasInvWarehouse::model()->findAll(array("select"=>"id","condition"=>"isBaseWareHouse='Y'"));
        	
        	$default_warehouse_id=$arr_default_warehouse{0}->id;
        	//echo $default_warehouse_id;
        	$model 					= new ProductLocation();
        	$model->stock_id 		= $id;
        	$model->bin 			= 0;
        	$model->rack 			= 0;
        	$model->warehouse_id 	= $default_warehouse_id;
        	$model->quantity 		= 0;
        	$model->save();
        	
        	$modelProductLocation = ProductLocation::model()->findAll(array('condition'=>'stock_id='.$id.' and warehouse_id!=""'));
        }
        //end
        //exit;
        foreach($modelProductLocation as $eachData){
            $data[] = MasInvWarehouse::model()->findByPk($eachData->warehouse_id);
        }
       return CHtml::listData($data, 'id', 'name');
 }
 
  public static function getDefaultWarehouse() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND isBaseWareHouse="Y"';
    	$model = self::model()->find(array('condition' => $condition));
        return $model;
    }
    
    public static function getInvoiceTypeWarehouse($id) {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y" AND id IN ('.$id.')';
    	$model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'warehouse_name');        
    }
}
