<?php

/**
 * This is the model class for table "{{mas_inv_rack}}".
 *
 * The followings are the available columns in table '{{mas_inv_rack}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property InventoryItems[] $inventoryItems
 * @property MasInvBin[] $masInvBins
 */
class MasInvRack extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_inv_rack}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'required'),
            array('name', 'length', 'max' => 255),
            array('name', 'unique'),
            array('name', 'filter', 'filter'=>'trim'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'inventoryItems' => array(self::HAS_MANY, 'InventoryItems', 'rack'),
            'masInvBins' => array(self::HAS_MANY, 'MasInvBin', 'rack_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
 
        public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('rack_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasInvRack the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getRacks() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'isActive =  "Y"';
    	$model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'name');
    }

}
