<?php

/**
 * This is the model class for table "{{mas_file}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property string $alert


 * @property string $isActive
 */
class MasFile extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_file}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('title,file_name', 'required'),
            array('title, file_name', 'length', 'max' => 255),
 
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('alert', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'Title',
            'file_name' => 'File',
            'remarks' => 'Remarks',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $searchterm = trim(Yii::app()->request->getParam('searchterm'));

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('file_name', $this->file_name, true);
        $criteria->compare('remarks', $this->remarks, true);
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.title like "%' . $searchterm . '%" OR 
                                        t.file_name like "%' . $searchterm . '%" OR 
                                        t.remarks like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
   

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
	
   

}