<?php

/**
 * This is the model class for table "{{mas_company}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property string $company_logo
 * @property integer $crm_user_id
 * @property string $company_name
 * @property string $billing_address
 * @property string $billing_city
 * @property string $billing_postalcode
 * @property string $billing_state
 * @property string $billing_country
 * @property string $billing_pinzip
 * @property string $shipping_address_same_as_billing
 * @property string $shipping_address
 * @property string $shipping_city
 * @property string $shipping_state
 * @property string $shipping_country
 * @property string $shipping_postalcode
 * @property string $shipping_pinzip
 * @property string $cut_off_date
 * @property string $cut_off_msg
 * @property string $billed_date
 * @property string $billed_msg
 * @property string $reminder_date
 * @property string $reminder_msg
 * @property string $youtube
 * @property string $googleplus 
 * @property string $genral_phno
 * @property string $genral_email
 * @property string $genral_location
 * @property string $genral_fax
 * @property string $genral_web
 * @property string $genral_industry
 * @property string $genral_latitude
 * @property string $genral_longitude
 * @property integer $currency_id
 * @property string $isActive
 */
class MasCompany extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    
    const MainDB = 'blskymine_logistics_main';
    
    public function tableName() {
        return 'blskymine_logistics_main.{{mas_company}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('company_name, billing_address,billing_country,  
                                  
                            
                               currency_id', 'required'),
            array('crm_user_id, currency_id, fin_year', 'numerical', 'integerOnly' => true),
            array('company_logo, company_name, billing_city, billing_postalcode, billing_state, billing_country, billing_pinzip, 
                            shipping_address, shipping_city, shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, cut_off_date, 
                            cut_off_msg, billed_date, billed_msg, reminder_date, reminder_msg, youtube, googleplus,  genral_phno, genral_email, genral_location, 
                            genral_fax, genral_web, genral_industry, genral_latitude, genral_longitude,trn_no,excise_no', 'length', 'max' => 255),
             array('footer_line_one,footer_line_two,footer_autogenerated', 'length', 'max' => 500),
            array('shipping_address_same_as_billing, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('company_logo, crm_user_id, company_name, billing_address, billing_city, billing_postalcode, billing_state, 
                            billing_country, billing_pinzip, shipping_address_same_as_billing, shipping_address, shipping_city, shipping_state, 
                            shipping_country, shipping_postalcode, shipping_pinzip, cut_off_date, cut_off_msg, billed_date, billed_msg, reminder_date, reminder_msg, 
                            youtube, googleplus,    genral_phno, genral_email, genral_location, genral_fax, genral_web, genral_industry, 
                            genral_latitude, genral_longitude, currency_id, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'currencydetails' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
             'country' => array(self::BELONGS_TO, 'MasCountry','billing_country'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'company_logo' => 'Company Logo',
            'crm_user_id' => 'Crm User',
            'company_name' => 'Company Name',
            'billing_address' => 'Billing Address',
            'billing_city' => 'Billing City',
            'billing_postalcode' => 'Billing Postalcode',
            'billing_state' => 'Billing State',
            'billing_country' => 'Billing Country',
            'billing_pinzip' => 'Billing Pinzip',
            'shipping_address_same_as_billing' => 'Shipping Address Same As Billing',
            'shipping_address' => 'Shipping Address',
            'shipping_city' => 'Shipping City',
            'shipping_state' => 'Shipping State',
            'shipping_country' => 'Shipping Country',
            'shipping_postalcode' => 'Shipping Postalcode',
            'shipping_pinzip' => 'Shipping Pinzip',
            'cut_off_date' => 'cut_off_date',
            'cut_off_msg' => 'cut_off_msg',
            'billed_date' => 'billed_date',
            'billed_msg' => 'billed_msg',
            'reminder_date' => 'reminder_date',
            'reminder_msg' => 'reminder_msg',
            'youtube' => 'Youtube',
            'googleplus' => 'Googleplus',
            'genral_phno' => 'Genral Phno',
            'genral_email' => 'Genral Email',
            'genral_location' => 'Genral Location',
            'genral_fax' => 'Genral Fax',
            'genral_web' => 'Genral Web',
            'genral_industry' => 'Genral Industry',
            'genral_latitude' => 'Genral Latitude',
            'genral_longitude' => 'Genral Longitude',
            'currency_id' => 'Currency',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('company_logo', $this->company_logo, true);
        $criteria->compare('crm_user_id', $this->crm_user_id);
        $criteria->compare('company_name', $this->company_name, true);
        $criteria->compare('billing_address', $this->billing_address, true);
        $criteria->compare('billing_city', $this->billing_city, true);
        $criteria->compare('billing_postalcode', $this->billing_postalcode, true);
        $criteria->compare('billing_state', $this->billing_state, true);
        $criteria->compare('billing_country', $this->billing_country, true);
        $criteria->compare('billing_pinzip', $this->billing_pinzip, true);
        $criteria->compare('shipping_address_same_as_billing', $this->shipping_address_same_as_billing, true);
        $criteria->compare('shipping_address', $this->shipping_address, true);
        $criteria->compare('shipping_city', $this->shipping_city, true);
        $criteria->compare('shipping_state', $this->shipping_state, true);
        $criteria->compare('shipping_country', $this->shipping_country, true);
        $criteria->compare('shipping_postalcode', $this->shipping_postalcode, true);
        $criteria->compare('shipping_pinzip', $this->shipping_pinzip, true);
        $criteria->compare('cut_off_date', $this->cut_off_date, true);
        $criteria->compare('cut_off_msg', $this->cut_off_msg, true);
        $criteria->compare('billed_date', $this->billed_date, true);
        $criteria->compare('billed_msg', $this->billed_msg, true);
        $criteria->compare('reminder_date', $this->reminder_date, true);
        $criteria->compare('reminder_msg', $this->reminder_msg, true);
        $criteria->compare('youtube', $this->youtube, true);
        $criteria->compare('googleplus', $this->googleplus, true);



        $criteria->compare('genral_phno', $this->genral_phno, true);
        $criteria->compare('genral_email', $this->genral_email, true);
        $criteria->compare('genral_location', $this->genral_location, true);
        $criteria->compare('genral_fax', $this->genral_fax, true);
        $criteria->compare('genral_web', $this->genral_web, true);
        $criteria->compare('genral_industry', $this->genral_industry, true);
        $criteria->compare('genral_latitude', $this->genral_latitude, true);
        $criteria->compare('genral_longitude', $this->genral_longitude, true);
        $criteria->compare('currency_id', $this->currency_id);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getBillingAddress() {
        $address = array();
        /*if (!$branch && (int) Yii::app()->user->master_user_branch_id == 0)
            $address[] = $this->billing_address;
        else {
            $branch = MasCompanyBranch::model()->findByPK(Yii::app()->user->master_user_branch_id);
            //$address[] = $branch->branch_name;
            $address[] = $branch->bill_address1;
            $address[] = $branch->bill_address2;
        }*/
		$mas_company = MasCompany::model()->findByPK(Yii::app()->user->master_user_company_id);
        $address[] = $mas_company->billing_address;
        $address[] = $mas_company->billing_city;
        return (implode(', ', array_filter($address)));
    }

    /* retuns full shipping address */

    public function getShippingAddress() {
        $address = array();
        /*if (!$branch && (int) Yii::app()->user->master_user_branch_id == 0)
            $address[] = $this->shipping_address;
        else {
            $branch = MasCompanyBranch::model()->findByPK(Yii::app()->user->master_user_branch_id);
            //$address[] = $branch->branch_name;
            $address[] = $branch->shipp_address1;
            $address[] = $branch->shipp_address2;
        }*/
        $mas_company = MasCompany::model()->findByPK(Yii::app()->user->master_user_company_id);
        $address[] = $mas_company->shipping_address;
        $address[] = $mas_company->shipping_city;
        return (implode(', ', array_filter($address)));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
	
    public static function getCompanyName() {

        $condition = 'isActive =  "Y"';

        $model = self::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'company_name');
    }
    public static function getMasCompanyDetails($master_user_company_id=0)
    {
    	if($master_user_company_id > 0)
    	$arr_mas_company = MasCompany::model()->findByPK($master_user_company_id);
    	else
    	$arr_mas_company = MasCompany::model()->findByPK(Yii::app()->user->master_user_company_id);
    	//echo '<pre>';
    	//print_r($arr_mas_company);
    	return $arr_mas_company;
    }
    public static function getCode($code){
        //$today  = date('Y-m-d');
        if($code != '')
             //return self::model()->find(array('condition' => 'company_code = "'.$code.'" AND cut_off_date < "'.$today.'"'))->id; 
             return self::model()->find(array('condition' => 'company_code = "'.$code.'"'))->id;
        else
             return 0;
    }


}
