<?php

/**
 * This is the model class for table "{{inventory_items}}".
 *
 * The followings are the available columns in table '{{inventory_items}}':
 * @property integer $stock_id
 * @property double $weight
 * @property integer $bin
 * @property integer $rack
 * @property integer $default_warehouse
 * @property integer $re_order_level
 * @property integer $re_order_lot
 * @property string $hsir_code
 * @property string $version
 * @property string $bar_code
 * @property string $others
 * @property integer $batch_no
 * @property string $manuf_date
 * @property string $expiry_date
 * @property integer $lot_no
 * @property string $notes
 */
class InventoryItems extends CActiveRecord
{
        public $sum_of_quantity;
        public $sum_of_total_value;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('stock_id, re_order_level, re_order_lot, batch_no, lot_no', 'numerical', 'integerOnly'=>true),
			//array('weight', 'numerical'),
			array('re_order_level, re_order_lot, hsir_code, version, bar_code, others, batch_no, manuf_date, 
                            expiry_date, lot_no, notes', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('re_order_level, re_order_lot, hsir_code, version, bar_code, others, batch_no, manuf_date, expiry_date, lot_no, notes', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'store' => array(self::BELONGS_TO, 'Store', 'stock_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			
			
			're_order_level' => 'Re Order Level',
			're_order_lot' => 'Re Order Lot',
			'hsir_code' => 'HS Code',
			'version' => 'Version',
			'bar_code' => 'Bar Code',
			'others' => 'Others',
			'batch_no' => 'Batch No',
			'manuf_date' => 'Manuf. Date',
			'expiry_date' => 'Expiry Date',
			'lot_no' => 'Lot No',
			'notes' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		
		$criteria->compare('re_order_level',$this->re_order_level);
		$criteria->compare('re_order_lot',$this->re_order_lot);
		$criteria->compare('hsir_code',$this->hsir_code,true);
		$criteria->compare('version',$this->version,true);
		$criteria->compare('bar_code',$this->bar_code,true);
		$criteria->compare('others',$this->others,true);
		$criteria->compare('batch_no',$this->batch_no);
		$criteria->compare('manuf_date',$this->manuf_date,true);
		$criteria->compare('expiry_date',$this->expiry_date,true);
		$criteria->compare('lot_no',$this->lot_no);
		$criteria->compare('notes',$this->notes,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InventoryItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
