<?php

/**
 * This is the model class for table "{{goods_return_item}}".
 *
 * The followings are the available columns in table '{{goods_return_item}}':
 * @property integer $id
 * @property integer $goods_return_id
 * @property integer $product_id
 * @property double $quantity
 * @property double $net_amount
 *
 * The followings are the available model relations:
 * @property GoodsReturn $goodsReturn
 * @property Store $product
 */
class GoodsReturnItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{goods_return_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('goods_return_id, product_id, quantity, net_amount', 'required'),
			array('goods_return_id, product_id', 'numerical', 'integerOnly'=>true),
			array('quantity, net_amount', 'numerical'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, goods_return_id, product_id, quantity, net_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'goodsReturn' => array(self::BELONGS_TO, 'GoodsReturn', 'goods_return_id'),
			'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'goods_return_id' => 'Goods Return',
			'product_id' => 'Product',
			'quantity' => 'Quantity',
			'net_amount' => 'Net Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('goods_return_id',$this->goods_return_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('net_amount',$this->net_amount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return GoodsReturnItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
