<?php

/**
 * This is the model class for table "crm_form_boq_general".
 *
 * The followings are the available columns in table 'crm_form_boq_general':
 * @property integer $id
 * @property integer $form_id
 * @property integer $file_id
 * @property string $project_name
 * @property string $date_of_submission
 * @property string $project_location
 * @property string $power_supply_voltage
 * @property string $power_supply_phase
 * @property string $power_supply_frequency
 * @property string $ambient_temperature
 * @property string $altitude_above_sea_level
 * @property string $water_temperature
 * @property string $lift_station_position
 * @property string $equilization_tank
 * @property string $product_water_bavkwash_tank
 * @property string $invert_level_equilization_tank
 * @property string $size_of_pipe_equilization_tank
 * @property integer $method_of_shipment
 * @property string $created_date
 */
class FormBoqGeneral extends CActiveRecord
{ 
       public $tenderid;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{form_boq_general}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('form_id, file_id, project_name, date_of_submission, project_location, power_supply_voltage, power_supply_phase, power_supply_frequency, ambient_temperature, altitude_above_sea_level, water_temperature, lift_station_position, equilization_tank, product_water_bavkwash_tank, invert_level_equilization_tank, size_of_pipe_equilization_tank, method_of_shipment, created_date', 'required'),
			array('tender_id', 'required'),
                        array('id,form_id, tender_id, method_of_shipment,person_in_charge', 'numerical', 'integerOnly'=>true),
			array('title, location, power_supply_voltage, power_supply_phase, power_supply_frequency, ambient_temperature, altitude_above_sea_level, water_temperature, lift_station_position, equilization_tank, product_water_bavkwash_tank, invert_level_equilization_tank, size_of_pipe_equilization_tank,plant_civil_layout,drainage,value_of_contract', 'length', 'max'=>255),
			array('notes,terms_and_conditions,remarks,date_of_submission', 'safe'),
			// @todo Please remove those attributes that should not be searched.
			array('id, form_id, tender_id,crm_user_id, title, date_of_submission, location, power_supply_voltage, power_supply_phase, power_supply_frequency, ambient_temperature, altitude_above_sea_level, water_temperature,plant_civil_layout,drainage,latest_sewage_water_analysis, lift_station_position, equilization_tank, product_water_bavkwash_tank, invert_level_equilization_tank, size_of_pipe_equilization_tank, method_of_shipment,notes,terms_and_conditions,remarks, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
           // 'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'items' => array(self::HAS_MANY, 'FormBoqGeneralItem', 'form_boq_id'),
            //'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'tender' => array(self::BELONGS_TO, 'TenderEnquireyDetals', 'tender_id'),
            'formBoqGeneralItem' => array(self::HAS_MANY, 'FormBoqGeneralItem', 'form_boq_id'),
            'formBoqConumables' => array(self::HAS_MANY, 'FormBoqYearlyConsumables', 'form_boq_id'),
            'formBoqRecommended' => array(self::HAS_MANY, 'FormBoqRecommendedSpareParts', 'form_boq_id'),
            //'currency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'tender' => array(self::BELONGS_TO, 'TenderEnquireyDetals', 'tender_id'),
            
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'form_id' => 'Form',
			'tender_id' => 'Tender No.',
			'title' => 'Title',
			'date_of_submission' => 'Date of Submission',
			'location' => 'Location',
			'power_supply_voltage' => 'Power Supply Voltage',
			'power_supply_phase' => 'Power Supply Phase',
			'power_supply_frequency' => 'Power Supply Frequency',
			'ambient_temperature' => 'Ambient Temperature',
			'altitude_above_sea_level' => 'Altitude Above Sea Level',
			'water_temperature' => 'Water Temperature',
                        'plant_civil_layout' => 'Plant Civil Layout',
                        'drainage' => 'Drainage',
			'lift_station_position' => 'Lift Station Position',
			'equilization_tank' => 'Equilization Tank',
			'product_water_bavkwash_tank' => 'Product Water Backwash Tank',
			'invert_level_equilization_tank' => 'Invert Level Equilization Tank',
			'size_of_pipe_equilization_tank' => 'Size of Pipe Equilization Tank',
			'method_of_shipment' => 'Method of Shipment',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	/*public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('form_id',$this->form_id);
		$criteria->compare('tender_id',$this->tender_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('date_of_submission',$this->date_of_submission,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('power_supply_voltage',$this->power_supply_voltage,true);
		$criteria->compare('power_supply_phase',$this->power_supply_phase,true);
		$criteria->compare('power_supply_frequency',$this->power_supply_frequency,true);
		$criteria->compare('ambient_temperature',$this->ambient_temperature,true);
		$criteria->compare('altitude_above_sea_level',$this->altitude_above_sea_level,true);
		$criteria->compare('water_temperature',$this->water_temperature,true);
		$criteria->compare('lift_station_position',$this->lift_station_position,true);
		$criteria->compare('equilization_tank',$this->equilization_tank,true);
		$criteria->compare('product_water_bavkwash_tank',$this->product_water_bavkwash_tank,true);
		$criteria->compare('invert_level_equilization_tank',$this->invert_level_equilization_tank,true);
		$criteria->compare('size_of_pipe_equilization_tank',$this->size_of_pipe_equilization_tank,true);
		$criteria->compare('method_of_shipment',$this->method_of_shipment);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}*/
        
        public function search($searchterm = null)
	{
		$criteria=new CDbCriteria;
                $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('boq_search')) : $searchterm;
                if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.tender_id like "%' . $searchterm . '%" 
                                            ', 'AND');
        }	
            return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CrmFormBoqGeneral the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
         public function getCategories($tender_id){
            $boqGeneral = FormBoqGeneral::model()->find(array('condition'=>'tender_id='.$tender_id));
            $boqGeneralItems = FormBoqGeneralItem::model()->findAll(array('condition'=>'form_boq_id='.$boqGeneral->id));
            
            $category = array(); 
            foreach($boqGeneralItems as $eachItem){
                array_push($category,$eachItem->category_id);
               
            }
           
         $model = FormBoqSchedule::model()->findAll(array('condition'=>'id iN ('.implode(',',$category).')'));
         return CHtml::listData($model, 'id', 'schedule_name');
        }
}
