<?php

class FinVoucherAllocation extends CActiveRecord
{

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fin_voucher_allocation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voucher_no, allocation_id,account_id', 'required'),
			array('id, allocation_id,subledger', 'numerical', 'integerOnly'=>true),
			array('isAllocated', 'length', 'max'=>1),
			array('voucher_no, invoice_id', 'length', 'max'=>30),
			array('debit_opening_amount, credit_opening_amount, debit_allocate_amount, credit_allocate_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, isAllocated, voucher_no, allocation_id, invoice_id, debit_opening_amount, credit_opening_amount, debit_allocate_amount, credit_allocate_amount, due_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'sub' => array(self::BELONGS_TO, 'Subledger', 'subledger'),
                    'account' => array(self::BELONGS_TO, 'FinAccounts', 'account_id'), 
                    'ledger' => array(self::BELONGS_TO, 'FinGeneralLedger', 'invoice_id'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'isAllocated' => 'Is Allocated',
			'voucher_no' => 'Voucher No',
			'allocation_id' => 'Allocation',
			'invoice_id' => 'Invoice',
			'debit_opening_amount' => 'Debit Opening Amount',
			'credit_opening_amount' => 'Credit Opening Amount',
			'debit_allocate_amount' => 'Debit Allocate Amount',
			'credit_allocate_amount' => 'Credit Allocate Amount',
			'due_date' => 'Due Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
$searchterm = trim(Yii::app()->request->getParam('search'));
$start_date 	= trim(Yii::app()->request->getParam('start_date'));
$end_date = trim(Yii::app()->request->getParam('end_date'));
$current_date = date('Y-m-d');

		$criteria=new CDbCriteria;
               $criteria->with = array('ledger');
                $criteria->group='allocation_id';
                if($searchterm)
			      {
			      $criteria->addCondition('t.voucher_no like "%' . $searchterm . '%" OR t.invoice_id like "%' . $searchterm . '%" OR t.allocation_id like "%' . $searchterm . '%" OR ledger.item_description like "%' . $searchterm . '%" OR ledger.narration like "%' . $searchterm . '%" OR ledger.policy_no like "%' . $searchterm . '%"', 'AND');
			      }
                  if($start_date!="" && $end_date!="")
			      {
			      	
			      	$arr_start_date = explode("/",$start_date);
			      	
			      	$start_date = $arr_start_date[2]."-".$arr_start_date[1]."-".$arr_start_date[0];
			      	
			      	$arr_end_date = explode("/",$end_date);
			      	
			      	$end_date = $arr_end_date[2]."-".$arr_end_date[1]."-".$arr_end_date[0];
			      	
			      	$criteria->addCondition('t.allocate_date>="'.$start_date.'" AND t.allocate_date<="'.$end_date.'"', 'AND');
			      }
			      else 
			      {
			      	$criteria->addCondition('t.allocate_date="'.$current_date.'"', 'AND');
			      	$criteria->limit = 5;
			      }
                               
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
                    'sort' => array(
                'defaultOrder' => 't.id DESC,t.allocate_date DESC',
            ),
                    'pagination' => false,
		));

	}
}