<?php

/**
 * This is the model class for table "{{mas_bank}}".
 *
 * The followings are the available columns in table '{{mas_bank}}':
 * @property integer $id
 * @property string $bank_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class FinSettings extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fin_settings}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('account_no,attribute', 'required'),
          
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,account_no,item,attribute', 'safe', 'on' => 'search'),
         
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'acc' => array(self::BELONGS_TO, 'FinAccounts', 'account_no'),
             'attr' => array(self::BELONGS_TO, 'FooterItem', 'attribute'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
          
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
   

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public static function checkExistance($attr)
    {
             if($attr > 0)
                $model = self::model()->find(array('condition' => 'attribute = "'.$attr.'"'));
             else
                $model = new FinSettings;
             if(!empty($model)){
                // echo 'true';
                 return true;
             }else{
                 //echo 'false';
                 return false;
                 
             }
            
    }
     public static function getAccount($attr)
    {
         
             if($attr > 0)
                $model = self::model()->find(array('condition' => 'attribute = "'.$attr.'"'));
             else
                $model = new FinSettings;
             if(!empty($model)){
                 //echo 'acc = '.$attr.'-'.$model->account_no;;
                 return $model->account_no;
             }else{
                // echo 'acc - 0';
                 return 0;
             }
            
    }
}
