<?php

/**
 * This is the model class for table "{{fin_opening_balance}}".
 *
 * The followings are the available columns in table '{{fin_opening_balance}}':
 * @property integer $id
 * @property integer $account_id
 * @property integer $company_id
 * @property string $opening_balace
 * @property string $created_date
 */
class FinOpeningBalance extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fin_opening_balance}}';
    }

    
    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('account_id,opening_balace,type', 'required'),
            array('account_id, company_id,type', 'numerical', 'integerOnly' => true),
            array('account,opening_balace', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,account, account_id, company_id, opening_balace, created_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
            'account1' => array(self::BELONGS_TO, 'FinAccounts', 'mainacc'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'account_id' => 'Account',
            'account' => 'Account',
            'company_id' => 'Company',
            'opening_balace' => 'Opening Balace',
            'created_date' => 'Created Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        // @todo Please modify the following code to remove attributes that should not be searched.
        //$userModel = User::model()->findByPK(Yii::app()->user->id);
        $criteria = new CDbCriteria;
        $account=trim(Yii::app()->request->getParam('search_account'));
        $subledger=trim(Yii::app()->request->getParam('search_subledger'));
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('balance_search')) : $searchterm;
        $criteria->with = array('company','account1');
        if (!empty($subledger)) {
            $criteria->addCondition('company.id like "%' . $subledger . '%" OR company.company_name like "%' . $subledger . '%" 
                                            ', 'AND');
        }
        if (!empty($account)) {
            $criteria->addCondition('account1.description like "%' . $account . '%" OR account1.account_no like "%' . $account . '%"
                                            ', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id',
            ),
            // 'pagination' => false
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    /* public function search()
      {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria=new CDbCriteria;

      $criteria->compare('id',$this->id);
      $criteria->compare('account_id',$this->account_id);
      $criteria->compare('account',$this->account_id);
      $criteria->compare('company_id',$this->company_id);
      $criteria->compare('opening_balace',$this->opening_balace,true);
      $criteria->compare('created_date',$this->created_date,true);

      return new CActiveDataProvider($this, array(
      'criteria'=>$criteria,
      ));
      } */

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FinOpeningBalance the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getAccountCustomerVendor() {

        $a = $this->account;
        preg_match("/([a-zA-Z]+)(\\d+)/", $a, $matches);
        if ($matches[1] == 'c' || $matches[1] == 'v') {

            $modelCompany = Company::model()->findByPk($matches[2]);
            return $modelCompany->company_name;
        } else {
            $modelAccount = FinAccounts::model()->findByPk($matches[2]);
            return $modelAccount->description;
        }
    }

    public function getcreditbalance() {
        $modelFinAccounts = FinAccounts::model()->findByPK($this->account_id);

        $modelFinGeneralLedger = FinGeneralLedger::model()->findAll(array('condition' => 'account_id=' . $this->account_id . ' AND company_id=' . $this->company_id));
        foreach ($modelFinGeneralLedger as $eachItem) {
            $creditTotal = $creditTotal + $eachItem->credit;
            $debitTotal = $debitTotal + $eachItem->debit;
        }
        if ($modelFinAccounts->credit_type == 1)
            $creditBalanceTotal = $creditTotal - $debitTotal;
        else
            $creditBalanceTotal = $debitTotal - $creditTotal;

        if (strpos($creditBalanceTotal, '.') === false) {
            $creditBalanceTotal = $creditBalanceTotal . ".00";
        }
        return $creditBalanceTotal;
    }

}
