<?php

/**
 * This is the model class for table "{{mas_file}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property string $alert


 * @property string $isActive
 */
class FinGeneralLedgerHead extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fin_general_ledger_head}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('voucher_no,voucher_date,voucher_type,user_id', 'required'),
  
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('voucher_no,voucher_date,voucher_type,user_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'amount' => array(self::STAT, 'FinGeneralLedger', 'form_ref_no', 'select' => 'ABS(SUM(db_entered) - SUM(cr_entered))'),
            'sub' => array(self::BELONGS_TO, 'Subledger', 'subledger'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'voucher_no' => 'Voucher No',
            'voucher_date' => 'Date',
            'voucher_type' => 'Type',
            'user_id' => 'User',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($data=null) {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $searchterm = trim(Yii::app()->request->getParam('search'));
        $start_date = trim(Yii::app()->request->getParam('start_date'));
        $current_date = date('Y-m-d');
        if (!empty($start_date)) {
         $start_date=str_replace('/', '-', $start_date);
         $start_date=date("Y-m-d", strtotime($start_date));
        }
         $end_date = trim(Yii::app()->request->getParam('end_date'));
         if (!empty($end_date)) {
         $end_date=str_replace('/', '-', $end_date);
         $end_date =date("Y-m-d", strtotime($end_date));
         }
        $type = trim(Yii::app()->request->getParam('type'));
        $posted = trim(Yii::app()->request->getParam('post'));
        $criteria = new CDbCriteria;

        if (!empty($data)) {
            if($data=='AT'){
            $criteria->addCondition('voucher_type="SI" OR voucher_type="PI" OR voucher_type="SCN" OR voucher_type="PDN"', 'AND');    
            }
 else {
            $criteria->addCondition('voucher_type="'.$data.'"', 'AND');
 }
        }

        if (!empty($type)) {
                  if($type=='AT'){
            $criteria->addCondition('voucher_type="SI" OR voucher_type="PI"', 'AND');    
            }
 else {
            $criteria->addCondition('voucher_type="'.$type.'"', 'AND');
 }
        }
        if (!empty($searchterm)) {
            $criteria->addCondition('voucher_no like "%'.$searchterm.'%" OR comment like "%'.$searchterm.'%"', 'AND');
        }
        if (!empty($start_date) && !empty($end_date)) {
            $criteria->addCondition('voucher_date>="'.$start_date.'"', 'AND');
            $criteria->addCondition('voucher_date<="'.$end_date.'"', 'AND');
        }
        
        if (!empty($posted)) {
            $criteria->addCondition("t.posted ='$posted'", 'AND');
        }
        if(empty($start_date) && empty($end_date) && empty($searchterm))
        {
            $criteria->addCondition('voucher_date="'.$current_date.'"', 'AND');
			      	$criteria->limit = 5;
        }
        $criteria->order = 'id DESC';
        return new CActiveDataProvider($this, array(
            'pagination' => false,
            'criteria' => $criteria,
        ));
    }
   

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
	
   

}